SELECT * FROM (
	SELECT
	  distinct 
	  t.id_ AS id,
	  pd.id_ AS processDefinitionId,
	  pd.key_ AS processDefinitionKey,
	  pd.name_ AS processDefinitionName,
	  bo.process_title AS processTitle,
	  pi.id_ AS processInstanceId,
	  to_char(bo.create_time, 'yyyy-mm-dd hh24:mi:ss') AS createTime,
	  t.name_ AS taskName,
	  t.id_ AS taskId,
	  bo.runtime_status_id AS runTimeStatusId,
	  t.task_def_key_ AS taskDefinitionKey,
	  to_char(t.create_time_, 'yyyy-mm-dd hh24:mi:ss') AS preNodetime,
	  bo.full_name||'（'||bo.position_name||'）' AS createUserName
	FROM
	    act_ru_task t                   
	LEFT JOIN act_ru_identitylink i ON i.task_id_ = t.id_ 
	LEFT JOIN act_re_procdef pd ON pd.id_ = t.proc_def_id_  
	LEFT JOIN act_hi_procinst pi ON pi.proc_inst_id_ = t.proc_inst_id_
	LEFT JOIN ta_base_business_obj bo ON bo.id = pi.business_key_
	WHERE (
	      t.assignee_ = '${myTaskVo.assignee}' 
	      OR (
	      t.assignee_ IS NULL
	      AND i.user_id_ = '${myTaskVo.assignee}' 
	      )
	)         
	AND t.suspension_state_ = 1
	<#if myTaskVo.processInstanceId ?exists && myTaskVo.processInstanceId ?length gt 0>
		AND pi.id_ LIKE '%${myTaskVo.processInstanceId}%'
	</#if>
	<#if myTaskVo.processDefinitionKey ?exists && myTaskVo.processDefinitionKey ?length gt 0>
		AND pd.key_ LIKE '%${myTaskVo.processDefinitionKey}%'
	</#if>
	<#if myTaskVo.processDefinitionName ?exists && myTaskVo.processDefinitionName ?length gt 0>
		AND pd.name_ LIKE '%${myTaskVo.processDefinitionName}%'
	</#if>
	<#if myTaskVo.processTitle ?exists && myTaskVo.processTitle ?length gt 0>
		AND bo.process_title LIKE '%${myTaskVo.processTitle}%'
	</#if>
	<#if myTaskVo.createTime ?exists && myTaskVo.createTime ?length gt 0>
		AND to_char(bo.create_time,'yyyy-mm-dd') = '${myTaskVo.createTime}'
	</#if>
)
ORDER BY preNodetime DESC