SELECT DISTINCT 
	t.id,
	p.id AS positionId,
	p.position_code AS positionCode,
	t.customer_id AS customerId,
	p.position_name AS positionName,
	ptu.username AS userName,
	ptu.mobilephone AS mobilephone,
	p.business_group AS businessGroup,
	ptu.fullname AS fullname,
	o.id AS orgId,
	o.org_name AS orgName,
	t.create_date AS createDate,
    (SELECT LISTAGG(detail_code,';') WITHIN GROUP (ORDER BY type_code)
                 FROM tm_r_cust_pos_bg_detail d WHERE d.type_code = 'channelCode' AND d.business_group = t.business_group) AS channelCode,
    (SELECT LISTAGG(detail_name,';') WITHIN GROUP (ORDER BY type_code)
                 FROM tm_r_cust_pos_bg_detail d WHERE d.type_code = 'channelCode' AND d.business_group = t.business_group) AS channelName,
    (SELECT LISTAGG(detail_code,';') WITHIN GROUP (ORDER BY type_code)
                 FROM tm_r_cust_pos_bg_detail d WHERE d.type_code = 'productCode' AND d.business_group = t.business_group) AS productCode,
    (SELECT LISTAGG(detail_name,';') WITHIN GROUP (ORDER BY type_code)
                 FROM tm_r_cust_pos_bg_detail d WHERE d.type_code = 'productCode' AND d.business_group = t.business_group) AS productName,
    (SELECT LISTAGG(detail_code,';') WITHIN GROUP (ORDER BY type_code)
                 FROM tm_r_cust_pos_bg_detail d WHERE d.type_code = 'businessAreaCode' AND d.business_group = t.business_group) AS businessAreaCode,
    (SELECT LISTAGG(detail_name,';') WITHIN GROUP (ORDER BY type_code)
                 FROM tm_r_cust_pos_bg_detail d WHERE d.type_code = 'businessAreaCode' AND d.business_group = t.business_group) AS businessAreaName
  FROM tm_r_cust_pos_bg t
  LEFT JOIN tm_position p ON p.id = t.position_id
  LEFT JOIN tm_r_user_position ptup ON ptup.position_id = p.id
  LEFT JOIN tm_user ptu ON ptu.id = ptup.user_id
  LEFT JOIN tm_org o ON o.id = t.org_id
 WHERE t.customer_id = '${custPostVo.customerId}'
 ORDER BY t.create_date ASC
