SELECT U.*,
TC.CUSTOMER_NAME AS CUSTNAME,
TC.CUSTOMER_CODE AS CUSTCODE,
TC.ID AS CUSTID,
RE.ROLE_NAME AS ROLENAMES,
RE.ROLE_ID AS ROLEIDS
FROM TM_USER U
LEFT JOIN TM_R_USER_CUSTOMER TUC ON U.ID=TUC.USER_ID
LEFT JOIN TM_CUSTOMER TC ON TC.ID=TUC.CUSTOMER_ID
LEFT JOIN (
	SELECT T.ID,
listagg(TE.ROLE_NAME,',') within GROUP (order by T.ID) AS ROLE_NAME ,
listagg(TE.ID,',') within GROUP (order by T.ID) AS ROLE_ID 
	FROM TM_USER T JOIN TM_R_USER_ROLE TMR ON T.ID=TMR.USER_ID 
	JOIN TM_ROLE TE ON TE.ID=TMR.ROLE_ID GROUP BY T.ID
) RE
ON RE.ID = U.ID
WHERE 1=1 AND U.USER_TYPE=1
<#if tmUserVo.id ?exists&&tmUserVo.id ?length gt 0>
	AND U.ID = '${tmUserVo.id}'
</#if>
<#if tmUserVo.userName ?exists&&tmUserVo.userName ?length gt 0>
	AND U.USERNAME LIKE '%${tmUserVo.userName}%'
</#if>
<#if tmUserVo.fullName ?exists&&tmUserVo.fullName ?length gt 0>
	AND U.FULLNAME LIKE '%${tmUserVo.fullName}%'
</#if>
<#if tmUserVo.enableStatus ?exists&&tmUserVo.enableStatus ?length gt 0>
	AND U.ENABLE_STATUS = '${tmUserVo.enableStatus}'
</#if>
<#if tmUserVo.custName ?exists&&tmUserVo.custName ?length gt 0>
	AND TC.CUSTOMER_NAME LIKE '%${tmUserVo.custName}%'
</#if>
<#if tmUserVo.custId ?exists&&tmUserVo.custId ?length gt 0>
	AND TC.ID = '${tmUserVo.custId}'
</#if>
ORDER BY U.CREATE_DATE DESC