/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.mdm.function.transformer;

import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.util.ResourceUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.utils.PinyinUtil;
import com.biz.eisp.mdm.function.entity.TmFunctionEntity;
import com.biz.eisp.mdm.function.service.TmFunctionService;
import com.biz.eisp.mdm.function.vo.TmFunctionVo;
import com.biz.eisp.mdm.icon.entity.TmIconEntity;
import com.google.common.base.Function;
import java.io.Serializable;
import java.util.Date;

public class TmFunctionVoToTmFunctionEntity
implements Function<TmFunctionVo, TmFunctionEntity> {
    private TmFunctionService functionService;

    public TmFunctionVoToTmFunctionEntity(TmFunctionService functionService) {
        this.functionService = functionService;
    }

    public TmFunctionEntity apply(TmFunctionVo input) {
        TmIconEntity tmIcon;
        TmFunctionEntity tmFunction = null;
        if (jodd.util.StringUtil.isNotEmpty((String)input.getId())) {
            tmFunction = this.functionService.get(TmFunctionEntity.class, (Serializable)((Object)input.getId()));
            tmFunction.setUpdateDate(new Date());
            tmFunction.setUpdateName(ResourceUtil.getSessionUserName().getUserName());
        } else {
            tmFunction = new TmFunctionEntity();
            tmFunction.setCreateDate(new Date());
            tmFunction.setCreateName(ResourceUtil.getSessionUserName().getUserName());
        }
        if (StringUtil.isNotEmpty(input.getFunctionOrder())) {
            tmFunction.setFunctionOrder(0);
        }
        if (jodd.util.StringUtil.isNotBlank((String)input.getParentId())) {
            TmFunctionEntity function = this.functionService.get(TmFunctionEntity.class, (Serializable)((Object)input.getParentId()));
            if (function == null) {
                throw new BusinessException("\u8f6c\u6362\u83dc\u5355Vo\u5230Po\u65f6\uff0c\u4e0a\u7ea7\u83dc\u5355\u627e\u4e0d\u5230:" + input.getParentId());
            }
            tmFunction.setTmFunction(function);
            tmFunction.setFunctionLevel(Short.valueOf(String.valueOf(function.getFunctionLevel() + 1)));
        }
        if (jodd.util.StringUtil.isNotBlank((String)input.getIconId()) && (tmIcon = this.functionService.get(TmIconEntity.class, (Serializable)((Object)input.getIconId()))) == null) {
            throw new BusinessException("\u8f6c\u6362\u83dc\u5355Vo\u5230Po\u65f6\uff0c\u56fe\u6807\u4fe1\u606f\u627e\u4e0d\u5230:" + input.getIconId());
        }
        tmFunction.setFunctionName(input.getFunctionName());
        tmFunction.setHeadString(PinyinUtil.getPinYinHeadChar(input.getFunctionName()));
        tmFunction.setFunctionLevel(input.getFunctionLevel());
        tmFunction.setFunctionOrder(input.getFunctionOrder());
        tmFunction.setFunctionUrl(input.getFunctionUrl());
        tmFunction.setIsSystem(input.getIsSystem());
        return tmFunction;
    }
}

