/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.mdm.system.service.impl;

import com.biz.eisp.base.common.jsonmodel.ComboTree;
import com.biz.eisp.base.common.tag.bean.ComboTreeModel;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.ComboxTreeUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;
import com.biz.eisp.mdm.config.entity.TmMdmTableConfigEntity;
import com.biz.eisp.mdm.config.util.DynamicConfigUtil;
import com.biz.eisp.mdm.dict.entity.TmDictDataEntity;
import com.biz.eisp.mdm.dict.entity.TmDictTypeEntity;
import com.biz.eisp.mdm.dict.util.DictUtil;
import com.biz.eisp.mdm.system.service.InitListenerService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="initListenerService")
@Transactional
public class InitListenerServiceImpl
extends BaseServiceImpl
implements InitListenerService {
    @Override
    public void initAllTypeGroups() {
        List<TmDictTypeEntity> typeGroups = this.loadAll(TmDictTypeEntity.class);
        for (TmDictTypeEntity dictTypeEntity : typeGroups) {
            DictUtil.allDictType.put(dictTypeEntity.getDictTypeCode(), dictTypeEntity);
            List<TmDictDataEntity> list = this.findByProperty(TmDictDataEntity.class, "tmDictType.dictTypeCode", dictTypeEntity.getDictTypeCode());
            if (!CollectionUtil.listNotEmptyNotSizeZero(list)) continue;
            DictUtil.allDictData.put(dictTypeEntity.getDictTypeCode(), list);
        }
    }

    @Override
    public void initAllTableColumns() {
        String sql = "select table_Name from tm_mdm_table_config group by table_Name ";
        List<Map<String, Object>> list = this.findForMapList(sql, new Object[0]);
        for (Map<String, Object> map : list) {
            String tableName = (String)map.get("table_Name");
            List<TmMdmTableConfigEntity> tableColumns = this.findByPropertyisOrder(TmMdmTableConfigEntity.class, "tableName", tableName, true, "columnOrder");
            ArrayList<TmMdmTableConfigEntity> tableConfigImp = new ArrayList<TmMdmTableConfigEntity>();
            HashMap<String, TmMdmTableConfigEntity> allFieldEntity = new HashMap<String, TmMdmTableConfigEntity>();
            HashMap<String, String> fieldMap = new HashMap<String, String>();
            HashMap<String, String> clounmMap = new HashMap<String, String>();
            HashMap<String, String> cloumnDictTypeMap = new HashMap<String, String>();
            for (TmMdmTableConfigEntity tableColumn : tableColumns) {
                allFieldEntity.put(tableColumn.getField(), tableColumn);
                if (StringUtil.isNotEmpty((String)tableColumn.getDictType())) {
                    cloumnDictTypeMap.put(tableColumn.getField(), tableColumn.getDictType());
                }
                String columnDesc = StringUtil.isNotEmpty((String)tableColumn.getFieldName()) ? tableColumn.getFieldName() : tableColumn.getColumnDesc();
                clounmMap.put(tableColumn.getField(), columnDesc);
                fieldMap.put(tableColumn.getColumnName(), columnDesc);
                if (StringUtil.isNotEmpty(tableColumn.getImportOut())) {
                    String keyName = String.valueOf(tableColumn.getTableName()) + tableColumn.getField();
                    if (StringUtil.isNotEmpty((String)tableColumn.getFieldProperty())) {
                        keyName = String.valueOf(tableColumn.getTableName()) + tableColumn.getFieldProperty();
                    }
                    DynamicConfigUtil.allTableConfigByField.put(keyName.toLowerCase(), tableColumn);
                }
                if (!StringUtil.isNotEmpty(tableColumn.getAddShowMode()) || tableColumn.getAddShowMode() != 1) continue;
                tableConfigImp.add(tableColumn);
            }
            DynamicConfigUtil.allTableConfigEntity.put(tableName, allFieldEntity);
            DynamicConfigUtil.allTableConfigDictColumn.put(tableName, cloumnDictTypeMap);
            DynamicConfigUtil.allTableConfigField.put(tableName, fieldMap);
            DynamicConfigUtil.allTableConfigColumn.put(tableName, clounmMap);
            DynamicConfigUtil.allTableConfig.put(tableName.toLowerCase(), tableColumns);
            DynamicConfigUtil.allTableConfigImpColumn.put(tableName, tableConfigImp);
        }
    }

    @Override
    public void initDepart() {
        ComboxTreeUtil.currMap.clear();
        ArrayList<ComboTree> comboTrees = new ArrayList<ComboTree>();
        ComboTreeModel comboTreeModel = new ComboTreeModel("id", "orgName", "tmOrgList");
        List orgList = this.findByHql("from TmOrgEntity where tmOrg.id is null", new Object[0]);
        for (Object obj : orgList) {
            comboTrees.add(this.comboTree(obj, comboTreeModel, null, true));
        }
        ComboxTreeUtil.currMap.put(ComboxTreeUtil.comboxTag, comboTrees);
    }

    @Override
    public void refleshDepart(String orgId, String parentId, String departname, int type) {
        ArrayList<ComboTree> comboTrees = new ArrayList();
        if (StringUtil.isNotEmpty((String)orgId) && StringUtil.isNotEmpty((String)departname)) {
            ArrayList<ComboTree> newtree = new ArrayList<ComboTree>();
            ComboTree tp = new ComboTree();
            tp.setId(orgId);
            tp.setText(departname);
            newtree.add(tp);
            comboTrees = ComboxTreeUtil.currMap.put(ComboxTreeUtil.comboxTag, comboTrees);
            ComboxTreeUtil.makenewMap(comboTrees, newtree, orgId, parentId, type);
            ComboxTreeUtil.currMap.clear();
            ComboxTreeUtil.currMap.put(ComboxTreeUtil.comboxTag, comboTrees);
        }
    }
}

