/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.mdm.config.service.impl;

import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.mdm.config.entity.TmMdmTableConfigEntity;
import com.biz.eisp.mdm.config.service.DynamicConditionService;
import com.biz.eisp.mdm.config.util.DynamicConfigUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class DefaultDynamicConditionServiceImpl
implements DynamicConditionService {
    @Override
    public String findConditionList(Object businessVo, List<TmMdmTableConfigEntity> tmMdmTableConfigList) {
        String condition = "";
        if (CollectionUtil.listEmpty(tmMdmTableConfigList)) {
            throw new BusinessException("\u52a8\u6001\u67e5\u8be2\u5b57\u6bb5\u89e3\u6790\u5217\u8868\u6570\u636e\u4e3a\u7a7a");
        }
        for (TmMdmTableConfigEntity tableConfig : tmMdmTableConfigList) {
            String conditionSql = "";
            String joinColumn = tableConfig.getJoinColumn();
            if (StringUtil.isNotEmpty((String)joinColumn)) {
                String[] queryStatues = this.getFields(tableConfig.getQueryStatus());
                String[] queryModes = this.getFields(tableConfig.getQueryMode());
                String[] joinColumns = this.getFields(tableConfig.getJoinColumn());
                String[] showColumns = this.getFields(tableConfig.getFieldProperty());
                String[] formats = this.getFields(tableConfig.getFormat());
                for (int i = 0; i < joinColumns.length; ++i) {
                    String column = joinColumns[i];
                    String property = "";
                    if (showColumns.length > i) {
                        property = showColumns[i];
                    }
                    String queryMode = "";
                    if (queryModes.length > i) {
                        queryMode = queryModes[i];
                    }
                    String queryStatus = "";
                    if (queryStatues.length > i) {
                        queryStatus = queryStatues[i];
                    }
                    String format = "";
                    if (formats.length > i) {
                        format = formats[i];
                    }
                    String alias = tableConfig.getAlias();
                    if (StringUtil.isNotEmpty((String)tableConfig.getQueryMode()) && (tableConfig.getQueryMode().equals("accurate") || tableConfig.getQueryMode().equals("grade"))) {
                        column = tableConfig.getColumnName();
                        alias = "t";
                    }
                    conditionSql = conditionSql + this.getConditionByQueryMode(queryStatus, alias, queryMode, property, column, businessVo, format, tableConfig.getJoinTable());
                }
            } else {
                conditionSql = conditionSql + this.getConditionByQueryMode(tableConfig.getQueryStatus(), "t", tableConfig.getQueryMode(), tableConfig.getFieldProperty(), tableConfig.getColumnName(), businessVo, tableConfig.getFormat(), null);
            }
            condition = condition + conditionSql;
        }
        return condition;
    }

    private String[] getFields(String fields) {
        if (StringUtil.isNotEmpty((String)fields)) {
            return fields.split(",");
        }
        return new String[0];
    }

    private String getConditionByQueryMode(String queryStatus, String tableAlise, String queryMode, String propertyName, String columnName, Object businessVo, String format, String joinTable) {
        String condition = "";
        if (StringUtil.isNotEmpty((String)queryStatus) && queryStatus.equals("1")) {
            condition = this.buildCondition(queryMode, tableAlise, propertyName, columnName, businessVo, format, joinTable);
        }
        return condition;
    }

    private String buildCondition(String queryMode, String tableAlise, String propertyName, String columnName, Object businessVo, String format, String joinTable) {
        String condition = "";
        String column = "";
        column = columnName.indexOf(".") != -1 ? columnName : tableAlise + "." + columnName;
        if (StringUtils.isBlank((CharSequence)propertyName)) {
            return condition;
        }
        Object conditionValue = DynamicConfigUtil.getInstance().getPropertyValue(businessVo, propertyName);
        if (!StringUtil.isNotEmpty(conditionValue)) {
            return condition;
        }
        if (StringUtil.isNotEmpty((String)queryMode) && StringUtil.isNotEmpty((String)joinTable) && StringUtil.equals("grade", queryMode)) {
            condition = condition + "  AND " + column + " in (select id from " + joinTable + " start with id='" + conditionValue + "' CONNECT BY PRIOR id=PARENT_ID)";
        }
        if (StringUtil.isNotEmpty((String)queryMode) && StringUtil.isNotEmpty(conditionValue) && StringUtil.equals(queryMode, "single")) {
            condition = condition + "  AND " + column + " LIKE '%" + conditionValue + "%'";
        }
        if (StringUtil.isNotEmpty((String)queryMode) && StringUtil.equals(queryMode, "accurate")) {
            if (conditionValue.getClass().isAssignableFrom(Date.class)) {
                String formatStr = "yyyy-MM-dd hh:mm";
                if (StringUtil.isNotEmpty((String)format)) {
                    formatStr = format;
                }
                SimpleDateFormat sdm = new SimpleDateFormat(formatStr);
                condition = condition + " AND TO_CHAR(" + column + ",'" + formatStr + "')" + "='" + sdm.format(conditionValue) + "'";
            } else {
                condition = condition + "  AND " + column + " = '" + conditionValue + "'";
            }
        }
        if (StringUtil.isNotEmpty((String)queryMode) && StringUtil.equals(queryMode, "group")) {
            Object propertyBegin = DynamicConfigUtil.getInstance().getPropertyValue(businessVo, propertyName + "_begin");
            Object propertyEnd = DynamicConfigUtil.getInstance().getPropertyValue(businessVo, propertyName + "_end");
            if (propertyBegin != null && propertyEnd != null) {
                SimpleDateFormat sdm;
                String formatStr = "yyyy-MM-dd hh:mm";
                if (StringUtil.isNotEmpty((String)format)) {
                    formatStr = format;
                }
                if (propertyBegin.getClass().isAssignableFrom(Date.class)) {
                    sdm = new SimpleDateFormat(formatStr);
                    condition = condition + " AND TO_CHAR(" + column + ",'" + formatStr + "')" + ">='" + sdm.format(propertyBegin + "'");
                } else {
                    condition = condition + " AND " + column + ">=" + propertyBegin;
                }
                if (propertyEnd.getClass().isAssignableFrom(Date.class)) {
                    sdm = new SimpleDateFormat(formatStr);
                    condition = condition + " AND TO_CHAR(" + column + ",'" + formatStr + "')" + "<='" + sdm.format(propertyEnd + "'");
                } else {
                    condition = condition + " AND " + column + "<=" + propertyEnd;
                }
            }
        }
        return condition + "";
    }
}

