/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.mdm.customer.controller;

import com.alibaba.fastjson.JSONObject;
import com.biz.eisp.base.common.jsonmodel.ComboBox;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.core.page.EuPage;
import com.biz.eisp.base.core.web.BaseController;
import com.biz.eisp.mdm.customer.service.TmCustPostService;
import com.biz.eisp.mdm.customer.vo.TmCustPostVo;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/tmCustPostController"})
public class TmCustPostController
extends BaseController {
    @Autowired
    private TmCustPostService tmCustPostService;

    @RequestMapping(params={"goTmCustPostMain"})
    public ModelAndView goTmCustPostMain(TmCustPostVo custPostVo, HttpServletRequest request) {
        String customerId = request.getParameter("customerId");
        String businessGroup = request.getParameter("businessGroup");
        String terminalId = request.getParameter("terminalId");
        request.setAttribute("terminalId", (Object)terminalId);
        request.setAttribute("customerId", (Object)customerId);
        request.setAttribute("businessGroup", (Object)businessGroup);
        return new ModelAndView("com/biz/eisp/mdm/tmCustomer/customerPosition");
    }

    @RequestMapping(params={"deleteCustPost"})
    @ResponseBody
    public JSONObject deleteCustPost(TmCustPostVo custPostVo, HttpServletRequest request, HttpServletResponse response) {
        this.tmCustPostService.deleteTmCustPost(custPostVo);
        return this.returnJson();
    }

    @RequestMapping(params={"businessGroupCombox"})
    public void businessGroupCombox(HttpServletRequest request, HttpServletResponse response) {
        List<ComboBox> dictDataList = this.tmCustPostService.comboBoxByDict("business_group");
        this.sendResponseObj(response, dictDataList);
    }

    @RequestMapping(params={"findTmCustPostList"})
    @ResponseBody
    public DataGrid findTmCustPostList(TmCustPostVo customerVo, HttpServletRequest request, HttpServletResponse response) {
        EuPage page = new EuPage(request);
        List<TmCustPostVo> custPostList = this.tmCustPostService.findPostList(customerVo, page);
        return new DataGrid(custPostList, page);
    }

    @RequestMapping(params={"goCustomerBindPosMain"})
    public ModelAndView goCustomerBindPosMain(HttpServletRequest request, TmCustPostVo tmCustPostVo) {
        request.setAttribute("posId", (Object)tmCustPostVo.getPositionId());
        request.setAttribute("businessGroup", (Object)tmCustPostVo.getBusinessGroup());
        request.setAttribute("custUser", (Object)tmCustPostVo.getCustUser());
        return new ModelAndView("com/biz/eisp/mdm/tmCustomer/customerBindPosMain");
    }
}

