/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.activiti.designer.processconf.service.impl;

import com.biz.eisp.activiti.designer.processconf.entity.TaProcessEntity;
import com.biz.eisp.activiti.designer.processconf.service.TaProcessNodeService;
import com.biz.eisp.activiti.designer.processconf.service.TaProcessService;
import com.biz.eisp.activiti.designer.processconf.transformer.TaProcessEntityToTaProcessVo;
import com.biz.eisp.activiti.designer.processconf.transformer.TaProcessVoToTaProcessEntity;
import com.biz.eisp.activiti.designer.processconf.vo.TaProcessVo;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="taProcessService")
@Transactional
public class TaProcessServiceImpl
extends BaseServiceImpl
implements TaProcessService {
    @Autowired
    private TaProcessNodeService taProcessNodeService;

    @Override
    public List<TaProcessVo> findTaProcessList(TaProcessVo tpProcessVo, Page page) {
        String hql = "from TaProcessEntity where 1=1 ";
        ArrayList<Object> paramList = new ArrayList<Object>();
        if (StringUtils.isNotBlank((CharSequence)tpProcessVo.getProcessKey())) {
            hql = String.valueOf(hql) + " and processKey like ?";
            paramList.add("%" + tpProcessVo.getProcessKey() + "%");
        }
        if (StringUtils.isNotBlank((CharSequence)tpProcessVo.getProcessName())) {
            hql = String.valueOf(hql) + " and processName like ?";
            paramList.add("%" + tpProcessVo.getProcessName() + "%");
        }
        if (tpProcessVo.getProcessState() != null) {
            hql = String.valueOf(hql) + " and processState = ?";
            paramList.add(tpProcessVo.getProcessState());
        }
        List entityList = this.findByHql(hql, page, paramList.toArray());
        List voList = Lists.transform(entityList, (Function)new TaProcessEntityToTaProcessVo());
        return voList;
    }

    @Override
    public void saveTaProcess(TaProcessVo taProcessVo, Page page) {
        TaProcessEntity entity = new TaProcessVoToTaProcessEntity(this, this.taProcessNodeService).apply(taProcessVo);
        this.saveOrUpdate(entity);
    }

    @Override
    public void deleteTaProcess(TaProcessVo taProcessVo, Page page) {
        TaProcessEntity entity = this.get(TaProcessEntity.class, (Serializable)((Object)taProcessVo.getId()));
        this.delete(entity);
    }

    @Override
    public TaProcessVo findProcessByKey(String key) {
        String hql = "from TaProcessEntity t where t.processKey = ?";
        List entity = this.findByHql(hql, key);
        TaProcessVo result = new TaProcessEntityToTaProcessVo().apply((TaProcessEntity)entity.get(0));
        return result;
    }
}

