/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.activiti.designer.processconf.transformer;

import com.biz.eisp.activiti.designer.processconf.entity.TaProcessEntity;
import com.biz.eisp.activiti.designer.processconf.entity.TaProcessNodeEntity;
import com.biz.eisp.activiti.designer.processconf.service.TaProcessNodeService;
import com.biz.eisp.activiti.designer.processconf.service.TaProcessService;
import com.biz.eisp.activiti.designer.processconf.vo.TaProcessVo;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.utils.StreamUtils;
import com.google.common.base.Function;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class TaProcessVoToTaProcessEntity
implements Function<TaProcessVo, TaProcessEntity> {
    private TaProcessService taProcessService;
    private TaProcessNodeService taProcessNodeService;

    public TaProcessVoToTaProcessEntity(TaProcessService taProcessService, TaProcessNodeService taProcessNodeService) {
        this.taProcessService = taProcessService;
        this.taProcessNodeService = taProcessNodeService;
    }

    public TaProcessEntity apply(TaProcessVo vo) {
        TaProcessEntity entity = null;
        if (vo == null) {
            return null;
        }
        if ("0".equals(vo.getId())) {
            entity = new TaProcessEntity();
            List<TaProcessEntity> list = this.taProcessService.findByProperty(TaProcessEntity.class, "processKey", vo.getProcessKey());
            if (list.size() > 0) {
                throw new BusinessException("\u6d41\u7a0bKey\u91cd\u590d\u4e86");
            }
        } else {
            entity = this.taProcessService.get(TaProcessEntity.class, (Serializable)((Object)vo.getId()));
        }
        entity.setListenerClass(vo.getListenerClass());
        entity.setNote(vo.getNote());
        entity.setProcessKey(vo.getProcessKey());
        entity.setProcessName(vo.getProcessName());
        entity.setProcessState(vo.getProcessState());
        entity.setProcessXml(StreamUtils.StringTObyte(vo.getProcessDescriptor()));
        entity.setRedirectUrl(vo.getRedirectUrl());
        entity.setTableName(vo.getTableName());
        this.taProcessService.save(entity);
        String nodes = vo.getNodes();
        if (StringUtils.isNotBlank((CharSequence)nodes)) {
            String[] temp = nodes.split("@@@");
            int i = 0;
            while (i < temp.length) {
                TaProcessNodeEntity taProcessNodeEntity = null;
                String[] fileds = temp[i].split("###");
                String tid = fileds[0].substring(3);
                String name = fileds[1].substring(9);
                String roleCode = null;
                if (fileds.length > 2) {
                    roleCode = fileds[2].substring(9);
                }
                if ((taProcessNodeEntity = this.taProcessNodeService.getTaProcessNodeEntity(tid, vo.getProcessKey())) == null) {
                    taProcessNodeEntity = new TaProcessNodeEntity();
                    taProcessNodeEntity.setProcessNodeCode(tid);
                    taProcessNodeEntity.setProcessNodeName(name);
                    taProcessNodeEntity.setTaProcessEntity(entity);
                    this.taProcessService.save(taProcessNodeEntity);
                } else {
                    taProcessNodeEntity.setProcessNodeCode(tid);
                    taProcessNodeEntity.setProcessNodeName(name);
                    taProcessNodeEntity.setTaProcessEntity(entity);
                    this.taProcessService.updateEntity(taProcessNodeEntity);
                }
                ++i;
            }
        }
        return entity;
    }
}

