/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.activiti.runtime.transformer;

import com.biz.eisp.activiti.runtime.entity.TaBaseBusinessObjEntity;
import com.biz.eisp.activiti.runtime.service.TaProcessInstanceService;
import com.biz.eisp.activiti.runtime.vo.MyInstanceVo;
import com.google.common.base.Function;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.runtime.ProcessInstance;
import org.apache.commons.lang3.time.DateFormatUtils;

public class HistoricProcessInstanceToMyInstanceVo
implements Function<HistoricProcessInstance, MyInstanceVo> {
    private RepositoryService repositoryService;
    private RuntimeService runtimeService;
    private TaskService taskService;
    private TaProcessInstanceService taProcessInstanceService;

    public HistoricProcessInstanceToMyInstanceVo(RepositoryService repositoryService, RuntimeService runtimeService, TaskService taskService, TaProcessInstanceService taProcessInstanceService) {
        this.repositoryService = repositoryService;
        this.runtimeService = runtimeService;
        this.taskService = taskService;
        this.taProcessInstanceService = taProcessInstanceService;
    }

    public MyInstanceVo apply(HistoricProcessInstance hi) {
        String starttime = DateFormatUtils.format((Date)hi.getStartTime(), (String)"yyyy-MM-dd HH:mm:ss");
        String endtime = hi.getEndTime() == null ? "" : DateFormatUtils.format((Date)hi.getEndTime(), (String)"yyyy-MM-dd HH:mm:ss");
        long totalTimes = hi.getEndTime() == null ? Calendar.getInstance().getTimeInMillis() - hi.getStartTime().getTime() : hi.getEndTime().getTime() - hi.getStartTime().getTime();
        long dayCount = totalTimes / 86400000L;
        long restTimes = totalTimes % 86400000L;
        long hourCount = restTimes / 3600000L;
        long minuteCount = (restTimes %= 3600000L) / 60000L;
        String spendTimes = String.valueOf(dayCount) + "\u5929" + hourCount + "\u5c0f\u65f6" + minuteCount + "\u5206";
        ProcessDefinition processDefinition = this.getProcessDefinition(hi.getProcessDefinitionId());
        String activityName = "";
        String activityUser = "";
        String taskId = "";
        MyInstanceVo vo = new MyInstanceVo();
        ProcessInstance pi = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(hi.getId()).singleResult();
        vo.setActivityName(activityName);
        vo.setActivityUser(activityUser);
        vo.setEndTime(endtime);
        vo.setId(hi.getId());
        vo.setProcessDefinitionName(processDefinition.getName());
        vo.setProcessDefinitionId(hi.getProcessDefinitionId());
        vo.setProcessInstanceId(hi.getId());
        vo.setSpendTimes(spendTimes);
        vo.setStartTime(starttime);
        vo.setStartPositionCode(hi.getStartUserId());
        vo.setProcessDefinitionKey(processDefinition.getKey());
        if (pi != null) {
            String businessObjId = pi.getBusinessKey();
            TaBaseBusinessObjEntity taBaseBusinessObjEntity = this.taProcessInstanceService.get(TaBaseBusinessObjEntity.class, (Serializable)((Object)businessObjId));
            vo.setProcessTitle(taBaseBusinessObjEntity.getProcessTitle());
        }
        return vo;
    }

    private ProcessDefinition getProcessDefinition(String processDefinitionId) {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionId(processDefinitionId).singleResult();
        return processDefinition;
    }
}

