/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.common.util;

import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.ContextHolderUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.service.BaseService;
import com.biz.eisp.base.utils.ApplicationContextUtils;
import com.biz.eisp.mdm.config.util.DBTypeUtil;
import com.biz.eisp.mdm.customer.entity.TmCustomerEntity;
import com.biz.eisp.mdm.custorg.entity.TmCustomerOrgEntity;
import com.biz.eisp.mdm.org.entity.TmOrgEntity;
import com.biz.eisp.mdm.position.vo.TmPositionVo;
import com.biz.eisp.mdm.role.vo.TmRoleVo;
import com.biz.eisp.mdm.user.entity.TmUserEntity;
import com.biz.eisp.mdm.user.service.TmUserService;
import com.biz.eisp.mdm.user.vo.TmUserVo;
import com.biz.eisp.mdm.web.pojo.ClientManager;
import java.util.List;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class ResourceUtil {
    public static String getRequestPath(HttpServletRequest request) {
        String requestPath = String.valueOf(request.getRequestURI()) + "?" + request.getQueryString();
        if (requestPath.indexOf("&") > -1) {
            requestPath = requestPath.substring(0, requestPath.indexOf("&"));
        }
        requestPath = requestPath.substring(request.getContextPath().length() + 1);
        return requestPath;
    }

    public static String getParameter(String field) {
        HttpServletRequest request = ContextHolderUtils.getRequest();
        return request.getParameter(field);
    }

    public static final TmUserEntity getSessionUserName() {
        HttpSession session = ContextHolderUtils.getSession();
        if (ClientManager.getInstance().getClient(session.getId()) != null) {
            return ClientManager.getInstance().getClient(session.getId()).getUser();
        }
        return null;
    }

    public static final TmCustomerEntity getSessionCustomer() {
        HttpSession session = ContextHolderUtils.getSession();
        if (ClientManager.getInstance().getClient(session.getId()) != null) {
            return ClientManager.getInstance().getClient(session.getId()).getCustomerEntity();
        }
        return null;
    }

    public static final TmPositionVo getCurrPosition() {
        HttpSession session = ContextHolderUtils.getSession();
        if (ClientManager.getInstance().getClient(session.getId()) != null) {
            return ClientManager.getInstance().getClient(session.getId()).getPosition();
        }
        return null;
    }

    public static final TmOrgEntity getCurrOrg() {
        HttpSession session = ContextHolderUtils.getSession();
        if (ClientManager.getInstance().getClient(session.getId()) != null) {
            return ClientManager.getInstance().getClient(session.getId()).getOrg();
        }
        return null;
    }

    public static final TmCustomerOrgEntity getCurrCustomerOrg() {
        HttpSession session = ContextHolderUtils.getSession();
        if (ClientManager.getInstance().getClient(session.getId()) != null) {
            return ClientManager.getInstance().getClient(session.getId()).getCustomerOrg();
        }
        return null;
    }

    public static TmUserVo getSessionTmUserVo() {
        TmUserService tmUserService = (TmUserService)ApplicationContextUtils.getContext().getBean("tmUserService");
        TmUserEntity tmUserEntity = ResourceUtil.getSessionUserName();
        TmUserVo tmUserVo = new TmUserVo();
        tmUserVo.setUserName(tmUserEntity.getUserName());
        return tmUserService.getTmUser(tmUserVo);
    }

    public static List<TmUserVo> getSessionTmUserList() {
        TmUserService tmUserService = (TmUserService)ApplicationContextUtils.getContext().getBean("tmUserService");
        TmUserEntity tmUserEntity = ResourceUtil.getSessionUserName();
        TmUserVo tmUserVo = new TmUserVo();
        tmUserVo.setUserName(tmUserEntity.getUserName());
        return tmUserService.getTmUserList(tmUserVo);
    }

    public static final String getTmRoleString() {
        if (StringUtil.isNotEmpty(ResourceUtil.getCurrPosition())) {
            BaseService baseService = (BaseService)ApplicationContextUtils.getContext().getBean("baseService");
            String positionId = ResourceUtil.getCurrPosition().getId();
            StringBuffer roleBuffer = new StringBuffer();
            String sql = "SELECT TR.ROLE_NAME AS roleName,TR.ROLE_CODE AS roleCode,TR.ID AS id FROM TM_ROLE TR JOIN TM_R_POSITION_ROLE TRPR ON TR.ID=TRPR.ROLE_ID  WHERE TRPR.POSITION_ID = ?";
            List<TmRoleVo> tmRoleVos = baseService.findBySql(TmRoleVo.class, sql, positionId);
            if (CollectionUtil.listNotEmptyNotSizeZero(tmRoleVos)) {
                for (TmRoleVo tmRoleVo : tmRoleVos) {
                    if (roleBuffer.length() > 0) {
                        roleBuffer.append(",");
                    }
                    roleBuffer.append(tmRoleVo.getRoleCode());
                }
            }
            return roleBuffer.toString();
        }
        return null;
    }

    public static final String getCreateName() {
        HttpSession session = ContextHolderUtils.getSession();
        if (StringUtil.isNotEmpty(session) && ClientManager.getInstance().getClient(session.getId()) != null) {
            TmUserEntity user = ClientManager.getInstance().getClient(session.getId()).getUser();
            TmPositionVo position = ClientManager.getInstance().getClient(session.getId()).getPosition();
            if (user == null || position == null) {
                return null;
            }
            return String.valueOf(user.getFullName()) + "(" + position.getPositionName() + ")";
        }
        return null;
    }

    public static final String getJdbcUrl() {
        return DBTypeUtil.getDBType().toLowerCase();
    }

    public static final String getSysConfigProperty(String propertyName) {
        String value = null;
        ResourceBundle rb = ResourceBundle.getBundle("sysconfig");
        if (rb.containsKey(propertyName)) {
            value = rb.getString(propertyName);
        }
        return value;
    }
}

