/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.mdm.custorg.transformer;

import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.utils.PinyinUtil;
import com.biz.eisp.mdm.custorg.entity.TmCustomerOrgEntity;
import com.biz.eisp.mdm.custorg.service.TmCustOrgService;
import com.biz.eisp.mdm.custorg.vo.TmCustomerOrgVo;
import com.google.common.base.Function;
import java.io.Serializable;
import jodd.util.StringUtil;

public class TmCustomerOrgVoToTmCustomerEntity
implements Function<TmCustomerOrgVo, TmCustomerOrgEntity> {
    private TmCustOrgService tmCustOrgService;

    public TmCustomerOrgVoToTmCustomerEntity(TmCustOrgService tmCustOrgService) {
        this.tmCustOrgService = tmCustOrgService;
    }

    public TmCustomerOrgEntity apply(TmCustomerOrgVo vo) {
        Integer baseLevel;
        TmCustomerOrgEntity custOrgEntity;
        TmCustomerOrgEntity tmCustOrgEntity = null;
        tmCustOrgEntity = StringUtil.isNotEmpty((String)vo.getId()) ? this.tmCustOrgService.get(TmCustomerOrgEntity.class, (Serializable)((Object)vo.getId())) : new TmCustomerOrgEntity();
        vo.setHeadString(PinyinUtil.getPinYinHeadChar(vo.getCustomerOrgName()));
        if (vo.getEnableStatus() == null) {
            vo.setEnableStatus(Globals.ZERO);
        }
        try {
            this.copyProperties(vo, tmCustOrgEntity);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (StringUtil.isNotBlank((String)vo.getParentId())) {
            custOrgEntity = this.tmCustOrgService.get(TmCustomerOrgEntity.class, (Serializable)((Object)vo.getParentId()));
            if (custOrgEntity == null) {
                throw new BusinessException("\u8f6c\u6362\u5ba2\u6237\u7ec4\u7ec7\u5173\u7cfbVo\u5230Po\u65f6\uff0c\u4e0a\u7ea7\u7ec4\u7ec7\u627e\u4e0d\u5230:" + vo.getParentId());
            }
            tmCustOrgEntity.setTmCustOrg(custOrgEntity);
            baseLevel = custOrgEntity.getCustOrgLevel() == null ? 0 : custOrgEntity.getCustOrgLevel();
            tmCustOrgEntity.setCustOrgLevel(baseLevel + 1);
        }
        if (StringUtil.isNotBlank((String)vo.getParentName())) {
            custOrgEntity = this.tmCustOrgService.findUniqueByProperty(TmCustomerOrgEntity.class, "custOrgCode", vo.getParentName());
            tmCustOrgEntity.setTmCustOrg(custOrgEntity);
            baseLevel = custOrgEntity.getCustOrgLevel() == null ? 0 : custOrgEntity.getCustOrgLevel();
            tmCustOrgEntity.setCustOrgLevel(baseLevel + 1);
        }
        if (StringUtil.isNotEmpty((String)vo.getCustomerOrgName())) {
            if (this.tmCustOrgService.validate(vo.getId(), vo.getCustomerOrgName(), "customerOrgName")) {
                throw new BusinessException("\u8f6c\u6362\u884c\u653f\u533a\u57df\u5173\u7cfbVo\u5230Po\u65f6\uff0c\u5ba2\u6237\u7ec4\u7ec7\u540d\u79f0" + vo.getCustomerOrgName() + "\u5df2\u5b58\u5728");
            }
        } else {
            throw new BusinessException("\u5ba2\u6237\u7ec4\u7ec7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isNotEmpty((String)vo.getCustOrgCode())) {
            if (this.tmCustOrgService.validate(vo.getId(), vo.getCustOrgCode(), "custOrgCode")) {
                throw new BusinessException("\u8f6c\u6362\u884c\u653f\u533a\u57df\u5173\u7cfbVo\u5230Po\u65f6\uff0c\u5ba2\u6237\u7ec4\u7ec7\u7f16\u7801" + vo.getCustOrgCode() + "\u5df2\u5b58\u5728");
            }
        } else {
            throw new BusinessException("\u5ba2\u6237\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (tmCustOrgEntity.getCustOrgLevel() == null) {
            tmCustOrgEntity.setCustOrgLevel(0);
        }
        return tmCustOrgEntity;
    }

    public void copyProperties(TmCustomerOrgVo vo, TmCustomerOrgEntity entity) {
        entity.setCustomerOrgName(vo.getCustomerOrgName());
        entity.setCustOrgCode(vo.getCustOrgCode());
        entity.setCustOrgDesc(vo.getCustOrgDesc());
        entity.setCustOrgType(vo.getCustOrgType());
        entity.setEnableStatus(vo.getEnableStatus());
        entity.setExtChar1(vo.getExtChar1());
        entity.setExtChar2(vo.getExtChar2());
        entity.setExtChar3(vo.getExtChar3());
        entity.setExtChar4(vo.getExtChar4());
        entity.setExtChar5(vo.getExtChar5());
        entity.setExtNumber1(vo.getExtNumber1());
        entity.setExtNumber2(vo.getExtNumber2());
        entity.setExtNumber3(vo.getExtNumber3());
        entity.setHeadString(vo.getHeadString());
    }
}

