select to_char(lo.create_date, 'yyyy-MM-dd hh24:mi:ss') createDate,
       lo.account,
       lo.name,
       decode(lo.type, '1', '通过', '2', '驳回', '3', '沟通', '通过') type,
       lo.content,
       p.position_name roleName,lo.task_def_key
  from ta_process_approval_log lo
  join act_hi_procinst inst
    on inst.proc_inst_id_ = lo.process_inst_id
  left join tm_user u
    on u.username = lo.account
  left join tm_r_user_position up
    on up.user_id = u.id
   and up.is_main = 0
  left join tm_position p
    on p.id = up.position_id
 where inst.proc_inst_id_ = :processInstanceId
   and lo.task_def_key is null

union

select *
  from (
        
        select to_char(lo_.create_date, 'yyyy-MM-dd hh24:mi:ss') createDate,
                lo_.account,
                lo_.name,
                decode(lo_.type, '1', '通过', '2', '驳回', '3', '沟通', '通过') type,
                lo_.content,
                case
                  when nvl(node.sign, 0) = 1 then
                   p.position_name
                  when nvl(node.sign, 0) != 1 and node.role_code is not null then
                   ro.role_name
                  else
                   p.position_name
                end roleName,lo_.task_def_key
          from ta_process_approval_log lo_
          join act_hi_procinst inst_
            on inst_.proc_inst_id_ = lo_.process_inst_id
          join ta_base_business_obj obj
            on obj.id = inst_.business_key_
          join ta_process_busiobj_config conf
            on conf.id = obj.process_busiobj_config_id
          left join ta_process_node node
            on node.process_id = conf.process_id
          left join tm_user u
            on u.username = lo_.account
          left join tm_r_user_role ur
            on ur.user_id = u.id
          left join tm_role ro1
            on ro1.id = ur.role_id
          left join tm_act_role ro
            on ro.role_code = node.role_code
          left join tm_r_user_position up
            on up.user_id = u.id
           and up.is_main = 0
          left join tm_position p
            on p.id = up.position_id
         where inst_.proc_inst_id_ = :processInstanceId
           and node.process_node_code = lo_.task_def_key
         order by lo_.create_date asc)
