/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.activiti.designer.processconf.controller;

import com.biz.eisp.activiti.designer.processconf.entity.TaProcessEntity;
import com.biz.eisp.activiti.designer.processconf.entity.TaProcessNodeEntity;
import com.biz.eisp.activiti.designer.processconf.service.TaProcessNodeService;
import com.biz.eisp.activiti.designer.processconf.transformer.TaProcessNodeEntityToTaProcessNodeVo;
import com.biz.eisp.activiti.designer.processconf.transformer.TaProcessNodeVoToTaProcessNodeEntity;
import com.biz.eisp.activiti.designer.processconf.vo.TaProcessNodeVo;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.jsonmodel.ValidForm;
import com.biz.eisp.base.common.util.OConvertUtils;
import com.biz.eisp.base.core.page.EuPage;
import com.biz.eisp.base.core.web.BaseController;
import com.biz.eisp.mdm.dict.service.TmDictDataService;
import java.io.Serializable;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/taProcessNodeController"})
public class TaProcessNodeController
extends BaseController {
    @Autowired
    private TaProcessNodeService taProcessNodeService;
    @Autowired
    private TmDictDataService tmDictDataService;

    @RequestMapping(params={"goProcessNodePropertiesForm"})
    public ModelAndView goProcessNodePropertiesForm(HttpServletRequest request) {
        String turn = OConvertUtils.getString(request.getParameter("turn"));
        String id = OConvertUtils.getString(request.getParameter("id"));
        String checkbox = OConvertUtils.getString(request.getParameter("checkbox"));
        String processId = OConvertUtils.getString(request.getParameter("processId"));
        String processDefinitionId = OConvertUtils.getString(request.getParameter("processDefinitionId"));
        TaProcessEntity taProcessEntity = this.taProcessNodeService.findUniqueByProperty(TaProcessEntity.class, "id", processDefinitionId);
        if (taProcessEntity != null) {
            request.setAttribute("processDefinitionId", (Object)taProcessEntity.getId());
            if (taProcessEntity.getTmDictDataEntity() != null) {
                request.setAttribute("typeId", (Object)taProcessEntity.getTmDictDataEntity().getId());
            }
            processId = taProcessEntity.getProcessKey();
            request.setAttribute("listenerClass", (Object)taProcessEntity.getListenerClass());
            request.setAttribute("tableName", (Object)taProcessEntity.getTableName());
            request.setAttribute("redirectUrl", (Object)taProcessEntity.getRedirectUrl());
        }
        request.setAttribute("checkbox", (Object)checkbox);
        request.setAttribute("id", (Object)id);
        request.setAttribute("processId", (Object)processId);
        request.setAttribute("key", (Object)processId);
        return new ModelAndView("com/biz/eisp/activiti/designer/processconf/processnode/" + turn);
    }

    @RequestMapping(params={"goTaProcessTabs"})
    public ModelAndView goTaProcessTabs(String processId) {
        ModelAndView view = new ModelAndView("com/biz/eisp/activiti/designer/processconf/taProcessTabs");
        view.addObject("processId", (Object)processId);
        return view;
    }

    @RequestMapping(params={"goTaProcessNodeMain"})
    public ModelAndView goTaProcessNodeMain(String taProcessId) {
        ModelAndView view = new ModelAndView("com/biz/eisp/activiti/designer/processconf/taProcessNodeMain");
        view.addObject("taProcessId", (Object)taProcessId);
        return view;
    }

    @RequestMapping(params={"findNodeBypdKey"})
    @ResponseBody
    public DataGrid findNodeBypdKey(String taProcessId, HttpServletRequest request, HttpServletResponse response) {
        EuPage page = new EuPage(request);
        List<TaProcessNodeVo> list = this.taProcessNodeService.getNodeByProcessId(taProcessId, page);
        return new DataGrid(list, page);
    }

    @RequestMapping(params={"goTaProcessNodeFrom"})
    public ModelAndView goTaProcessNodeForm(String id, String taProcessId) {
        ModelAndView view = new ModelAndView("com/biz/eisp/activiti/designer/processconf/taProcessNodeForm");
        TaProcessNodeVo vo = null;
        if (StringUtils.isNotBlank((CharSequence)id)) {
            TaProcessNodeEntity entity = this.taProcessNodeService.get(TaProcessNodeEntity.class, (Serializable)((Object)id));
            vo = new TaProcessNodeEntityToTaProcessNodeVo().apply(entity);
        } else {
            vo = new TaProcessNodeVo();
            vo.setTaProcessId(taProcessId);
        }
        view.addObject("nodeVo", (Object)vo);
        return view;
    }

    @RequestMapping(params={"saveOrUpdateTaProcessNode"})
    @ResponseBody
    public AjaxJson saveOrUpdateTaProcessNode(TaProcessNodeVo nodeVo) {
        AjaxJson aj = new AjaxJson();
        TaProcessNodeEntity entity = new TaProcessNodeVoToTaProcessNodeEntity(this.taProcessNodeService).apply(nodeVo);
        TaProcessEntity pe = this.taProcessNodeService.get(TaProcessEntity.class, (Serializable)((Object)nodeVo.getTaProcessId()));
        try {
            this.taProcessNodeService.saveOrUpdate(pe);
            aj.setSuccess(true);
            return aj;
        }
        catch (Exception e) {
            aj.setSuccess(false);
            throw new BusinessException("\u6570\u636e\u5e93\u64cd\u4f5c\u53d1\u751f\u9519\u8bef");
        }
    }

    @RequestMapping(params={"deleteTaProcessodeById"})
    @ResponseBody
    public AjaxJson deleteTaProcessNodeById(String id) {
        AjaxJson aj = new AjaxJson();
        String message = null;
        TaProcessNodeEntity entity = this.taProcessNodeService.get(TaProcessNodeEntity.class, (Serializable)((Object)id));
        if (entity.getTaProcessVariableEntityList().size() != 0 && entity.getTaRProcessNodeListenerEntityList().size() != 0) {
            message = "\u8282\u70b9:" + entity.getProcessNodeName() + "\u5df2\u7ecf\u5728\u4f7f\u7528\uff0c\u65e0\u6cd5\u5220\u9664\uff0c\u8bf7\u5148\u5c06\u6b63\u5728\u4f7f\u7528\u8be5\u8282\u70b9\u7684\u53d8\u91cf\u6216\u8005\u76d1\u542c\u5220\u9664";
        } else {
            this.taProcessNodeService.delete(entity);
            message = "\u6210\u529f\u5220\u9664\u8282\u70b9:" + entity.getProcessNodeName();
        }
        aj.setMsg(message);
        return aj;
    }

    @RequestMapping(params={"validateNode"})
    @ResponseBody
    public ValidForm validateNode(TaProcessNodeVo nodeVo, String param) {
        ValidForm vf = new ValidForm();
        try {
            vf = this.taProcessNodeService.validateNode(nodeVo, param);
        }
        catch (Exception e) {
            vf.setStatus("n");
            vf.setInfo("\u670d\u52a1\u5668\u9a8c\u8bc1\u9519\u8bef,\u8bf7\u91cd\u8bd5");
        }
        return vf;
    }
}

