/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.core.redis.aop;

import com.biz.eisp.base.core.redis.annotation.ParameterMapKeyProvider;
import com.biz.eisp.base.core.redis.annotation.ParameterValueKeyProvider;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.slf4j.Logger;

public abstract class CacheAdvice {
    public static final String ENABLE_CACHE_PROPERTY = "ssm.cache.enable";
    public static final String ENABLE_CACHE_PROPERTY_VALUE = "true";

    protected boolean isEnable() {
        return ENABLE_CACHE_PROPERTY_VALUE.equals(System.getProperty(ENABLE_CACHE_PROPERTY));
    }

    protected Method getMethod(ProceedingJoinPoint pjp) {
        Object[] args = pjp.getArgs();
        Class[] argTypes = new Class[pjp.getArgs().length];
        int i = 0;
        while (i < args.length) {
            argTypes[i] = args[i].getClass();
            ++i;
        }
        Method method = null;
        try {
            method = pjp.getTarget().getClass().getMethod(pjp.getSignature().getName(), argTypes);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        return method;
    }

    protected String getCacheKey(String namespace, String assignedKey, Annotation[][] ans, Object[] args) {
        StringBuilder sb = new StringBuilder();
        if (namespace != null && !namespace.equals("") && !namespace.equals("[unassigned]")) {
            sb.append(namespace);
            sb.append("_");
        }
        if (assignedKey != null && !assignedKey.equals("") && !assignedKey.equals("[unassigned]")) {
            sb.append(assignedKey);
            sb.append("_");
        }
        if (ans != null && ans.length > 0) {
            Annotation[][] annotationArray = ans;
            int n = ans.length;
            int n2 = 0;
            while (n2 < n) {
                Annotation[] anitem = annotationArray[n2];
                if (anitem.length > 0 && anitem[0] instanceof ParameterValueKeyProvider) {
                    Annotation[] annotationArray2 = anitem;
                    int n3 = anitem.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Annotation an = annotationArray2[n4];
                        ParameterValueKeyProvider vk = (ParameterValueKeyProvider)an;
                        sb.append(args[vk.order()]);
                        sb.append("_");
                        ++n4;
                    }
                    break;
                }
                ++n2;
            }
        }
        return sb.toString();
    }

    protected String getCacheMapValueKey(Annotation[][] ans, Object[] args) {
        StringBuilder sb = new StringBuilder();
        if (ans != null && ans.length > 0) {
            Annotation[][] annotationArray = ans;
            int n = ans.length;
            int n2 = 0;
            while (n2 < n) {
                Annotation[] anitem = annotationArray[n2];
                if (anitem.length > 0 && anitem[0] instanceof ParameterMapKeyProvider) {
                    Annotation[] annotationArray2 = anitem;
                    int n3 = anitem.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Annotation an = annotationArray2[n4];
                        ParameterMapKeyProvider vk = (ParameterMapKeyProvider)an;
                        sb.append(args[vk.order()]);
                        sb.append("_");
                        ++n4;
                    }
                    break;
                }
                ++n2;
            }
        }
        return sb.toString();
    }

    protected void warn(Exception e, String format, Object ... args) {
        if (this.getLogger().isWarnEnabled()) {
            this.getLogger().warn(String.format(format, args), (Throwable)e);
        }
    }

    protected abstract Logger getLogger();
}

