/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.core.redis.aop;

import com.biz.eisp.base.core.redis.annotation.DeleteThroughAssignCache;
import com.biz.eisp.base.core.redis.annotation.ReadCacheType;
import com.biz.eisp.base.core.redis.aop.CacheAdvice;
import com.biz.eisp.base.core.redis.cache.IRedisCacheService;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;

abstract class SingleDeleteCacheAdvice
extends CacheAdvice {
    @Autowired
    private IRedisCacheService redisCacheService;

    SingleDeleteCacheAdvice() {
    }

    protected Object delete(ProceedingJoinPoint pjp) throws Throwable {
        if (this.isEnable()) {
            this.getLogger().info("Cache disabled");
            return pjp.proceed();
        }
        Method method = this.getMethod(pjp);
        DeleteThroughAssignCache cacheable = method.getAnnotation(DeleteThroughAssignCache.class);
        Signature sig = pjp.getSignature();
        MethodSignature msig = (MethodSignature)sig;
        if (cacheable != null && cacheable.cacheEnable()) {
            String namespace = cacheable.namespace();
            String assignedKey = cacheable.assignedKey();
            Annotation[][] anns = method.getParameterAnnotations();
            if (cacheable.cacheType() == ReadCacheType.Map) {
                String mapkey = this.getCacheKey(namespace, assignedKey, anns, pjp.getArgs());
                String valuekey = this.getCacheMapValueKey(anns, pjp.getArgs());
                this.redisCacheService.removeMap(mapkey, valuekey);
                return pjp.proceed();
            }
            String key = this.getCacheKey(namespace, assignedKey, anns, pjp.getArgs());
            if (cacheable.cacheType() == ReadCacheType.String) {
                this.redisCacheService.remove(key);
                return pjp.proceed();
            }
        } else {
            this.getLogger().info("Method cache disabled . Name {}", (Object)msig.getName());
            return pjp.proceed();
        }
        return null;
    }
}

