/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.importer;

import com.alibaba.fastjson.JSONObject;
import com.biz.eisp.base.importer.ImpInfo;
import com.biz.eisp.base.importer.ImportMonitor;
import com.biz.eisp.base.importer.Importer;
import com.biz.eisp.base.importer.iterator.DataIterator;
import com.biz.eisp.base.importer.validator.ValidateException;
import com.biz.eisp.base.utils.ApplicationContextUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.FlushMode;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.orm.hibernate4.SessionFactoryUtils;
import org.springframework.orm.hibernate4.SessionHolder;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

public class ImportThreadWrapper
extends Thread
implements Importer,
ImportMonitor {
    public static final Log log = LogFactory.getLog((String)"ImportWrapper");
    public static final String STATE_RUNNING = "R";
    public static final String STATE_ERROR = "E";
    public static final String STATE_SUCCESS = "S";
    private Map<String, ImportMonitor> container;
    private String name;
    private Importer importer;
    private DataIterator iterator;
    private boolean test;
    private String impState;
    private ImpInfo impInfo;
    private String errInfo;
    private RequestAttributes attributes = RequestContextHolder.getRequestAttributes();
    private HttpSession httpSession;
    private HttpServletResponse response;

    public ImportThreadWrapper(Importer importer, HttpSession httpSession, HttpServletResponse response) {
        this.importer = importer;
        this.httpSession = httpSession;
        this.response = response;
    }

    @Override
    public boolean isTest() {
        return this.test;
    }

    @Override
    public String getImpState() {
        return this.impState;
    }

    @Override
    public ImpInfo getImpInfo() {
        return this.impInfo;
    }

    @Override
    public String getErrInfo() {
        return this.errInfo;
    }

    @Override
    public int getSize() {
        return this.importer.getIterator() != null ? this.importer.getIterator().getSize() : -1;
    }

    @Override
    public int getIndex() {
        return this.importer.getIterator() != null ? this.importer.getIterator().getIndex() : -1;
    }

    public void render(HttpServletResponse response, String mess, boolean flag) {
        response.setContentType("text/html;charset=utf-8");
        JSONObject obj = new JSONObject();
        obj.put("success", (Object)flag);
        obj.put("result", (Object)true);
        obj.put("message", (Object)mess);
        try (PrintWriter out = null;){
            try {
                out = response.getWriter();
                out.write(obj.toJSONString());
            }
            catch (IOException e) {
                e.printStackTrace();
                if (out != null) {
                    out.close();
                }
            }
        }
    }

    @Override
    public void run() {
        RequestContextHolder.setRequestAttributes((RequestAttributes)this.attributes);
        SessionFactory sessionFactory = (SessionFactory)ApplicationContextUtils.getContext().getBean("sessionFactory");
        Session session = null;
        boolean participate = false;
        if (TransactionSynchronizationManager.hasResource((Object)sessionFactory)) {
            participate = true;
        } else {
            session = sessionFactory.openSession();
            session.setFlushMode(FlushMode.NEVER);
            TransactionSynchronizationManager.bindResource((Object)sessionFactory, (Object)new SessionHolder(session));
        }
        try {
            try {
                this.impState = STATE_RUNNING;
                ImpInfo info = null;
                info = this.test ? this.importer.test(this.iterator) : this.importer.imp(this.iterator, this.httpSession);
                this.impState = STATE_SUCCESS;
                this.impInfo = info;
            }
            catch (Exception e) {
                this.impState = STATE_ERROR;
                this.errInfo = e.getMessage();
                if (!(e instanceof ValidateException)) {
                    e.printStackTrace();
                }
                try {
                    try {
                        if (!participate) {
                            TransactionSynchronizationManager.unbindResource((Object)sessionFactory);
                            SessionFactoryUtils.closeSession((Session)session);
                        }
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                        try {
                            try {
                                Thread.sleep(9000L);
                            }
                            catch (InterruptedException e3) {
                                e3.printStackTrace();
                                if (this.container != null) {
                                    this.container.remove(this.name);
                                    log.info((Object)("container remove; size: " + this.container.size()));
                                }
                            }
                        }
                        finally {
                            if (this.container != null) {
                                this.container.remove(this.name);
                                log.info((Object)("container remove; size: " + this.container.size()));
                            }
                        }
                    }
                }
                finally {
                    block76: {
                        try {
                            try {
                                Thread.sleep(9000L);
                            }
                            catch (InterruptedException e4) {
                                e4.printStackTrace();
                                if (this.container != null) {
                                    this.container.remove(this.name);
                                    log.info((Object)("container remove; size: " + this.container.size()));
                                }
                                break block76;
                            }
                        }
                        catch (Throwable throwable) {
                            if (this.container != null) {
                                this.container.remove(this.name);
                                log.info((Object)("container remove; size: " + this.container.size()));
                            }
                            throw throwable;
                        }
                        if (this.container != null) {
                            this.container.remove(this.name);
                            log.info((Object)("container remove; size: " + this.container.size()));
                        }
                    }
                }
            }
        }
        finally {
            block79: {
                try {
                    try {
                        if (!participate) {
                            TransactionSynchronizationManager.unbindResource((Object)sessionFactory);
                            SessionFactoryUtils.closeSession((Session)session);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        try {
                            try {
                                Thread.sleep(9000L);
                            }
                            catch (InterruptedException e5) {
                                e5.printStackTrace();
                                if (this.container != null) {
                                    this.container.remove(this.name);
                                    log.info((Object)("container remove; size: " + this.container.size()));
                                }
                                break block79;
                            }
                        }
                        catch (Throwable throwable) {
                            if (this.container != null) {
                                this.container.remove(this.name);
                                log.info((Object)("container remove; size: " + this.container.size()));
                            }
                            throw throwable;
                        }
                        if (this.container != null) {
                            this.container.remove(this.name);
                            log.info((Object)("container remove; size: " + this.container.size()));
                        }
                        break block79;
                    }
                }
                catch (Throwable throwable) {
                    block81: {
                        try {
                            try {
                                Thread.sleep(9000L);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                                if (this.container != null) {
                                    this.container.remove(this.name);
                                    log.info((Object)("container remove; size: " + this.container.size()));
                                }
                                break block81;
                            }
                        }
                        catch (Throwable throwable2) {
                            if (this.container != null) {
                                this.container.remove(this.name);
                                log.info((Object)("container remove; size: " + this.container.size()));
                            }
                            throw throwable2;
                        }
                        if (this.container != null) {
                            this.container.remove(this.name);
                            log.info((Object)("container remove; size: " + this.container.size()));
                        }
                    }
                    throw throwable;
                }
                try {
                    try {
                        Thread.sleep(9000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        if (this.container != null) {
                            this.container.remove(this.name);
                            log.info((Object)("container remove; size: " + this.container.size()));
                        }
                        break block79;
                    }
                }
                catch (Throwable throwable) {
                    if (this.container != null) {
                        this.container.remove(this.name);
                        log.info((Object)("container remove; size: " + this.container.size()));
                    }
                    throw throwable;
                }
                if (this.container != null) {
                    this.container.remove(this.name);
                    log.info((Object)("container remove; size: " + this.container.size()));
                }
            }
        }
    }

    @Override
    public ImpInfo imp(DataIterator iterator, HttpSession session) throws Exception {
        this.test = false;
        this.iterator = iterator;
        this.start();
        return this.impInfo;
    }

    @Override
    public ImpInfo test(DataIterator iterator) throws Exception {
        this.test = true;
        this.iterator = iterator;
        this.start();
        return null;
    }

    @Override
    public void template(HttpServletResponse response) throws Exception {
        this.importer.template(response);
    }

    @Override
    public DataIterator getIterator() {
        return this.importer.getIterator();
    }

    @Override
    public void toContainer(Map<String, ImportMonitor> container, String name) {
        this.container = container;
        this.name = name;
        container.put(name, this);
        log.info((Object)("container put; size: " + container.size()));
    }
}

