/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.importer;

import com.biz.eisp.base.importer.DataField;
import com.biz.eisp.base.importer.DefaultHibernateImporter;
import com.biz.eisp.base.importer.ImpConfigurator;
import com.biz.eisp.base.importer.ImportThreadWrapper;
import com.biz.eisp.base.importer.Importer;
import com.biz.eisp.base.importer.MultiLevelDataImporter;
import com.biz.eisp.base.importer.iterator.DataIterator;
import com.biz.eisp.base.importer.iterator.Excel2007DataIterator;
import com.biz.eisp.base.importer.iterator.ExcelDataIterator;
import com.biz.eisp.base.importer.iterator.TextDataIterator;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.lang.reflect.Constructor;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.poi.POIXMLDocument;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public class ImporterFactory {
    public static Importer createImporter(String configFile, Map<String, Object> params) throws Exception {
        ImpConfigurator conf = ImporterFactory.getConfigurator(configFile);
        if (conf.getMlKey() != null) {
            return new MultiLevelDataImporter(conf, params);
        }
        if (conf.getCustomDataImporter() != null) {
            try {
                Constructor constructor = conf.getCustomDataImporter().getConstructor(ImpConfigurator.class, Map.class);
                return (Importer)constructor.newInstance(conf, params);
            }
            catch (Exception e) {
                e.printStackTrace();
                return new DefaultHibernateImporter(conf, params);
            }
        }
        return new DefaultHibernateImporter(conf, params);
    }

    public static Importer createDelayImporter(String configFile, Map<String, Object> params) throws Exception {
        ImpConfigurator conf = ImporterFactory.getConfigurator(configFile);
        for (DataField field : conf.getFields()) {
            if (!field.getCode().contains(".")) continue;
            field.setOnError("skipCol");
        }
        if (conf.getMlKey() != null) {
            return new MultiLevelDataImporter(conf, params);
        }
        return new DefaultHibernateImporter(conf, params);
    }

    public static Importer createImportThreadWrapper(Importer importer, HttpSession httpSession, HttpServletResponse response) throws Exception {
        return new ImportThreadWrapper(importer, httpSession, response);
    }

    public static ImpConfigurator getConfigurator(String configFile) throws Exception {
        return ImpConfigurator.getConfigurator(configFile);
    }

    public static DataIterator getTextDataIterator(InputStream is, String regex) throws Exception {
        return new TextDataIterator(is, regex);
    }

    public static DataIterator getTextDataIterator(InputStream is, char delimiter) throws Exception {
        return new TextDataIterator(is, delimiter);
    }

    public static DataIterator getTextDataIterator(InputStream is, String regex, String charset) throws Exception {
        return new TextDataIterator(is, regex, charset);
    }

    public static DataIterator getTextDataIterator(InputStream is, char delimiter, String charset) throws Exception {
        return new TextDataIterator(is, delimiter, charset);
    }

    public static DataIterator getExcelDataIterator(String configFile, InputStream is, int sheetIndex) throws Exception {
        ImpConfigurator conf = ImporterFactory.getConfigurator(configFile);
        if (!is.markSupported()) {
            is = new PushbackInputStream(is, 8);
        }
        if (POIFSFileSystem.hasPOIFSHeader((InputStream)is)) {
            return new ExcelDataIterator(is, sheetIndex, conf.getFields());
        }
        if (POIXMLDocument.hasOOXMLHeader((InputStream)is)) {
            return new Excel2007DataIterator(is, sheetIndex, conf.getFields());
        }
        throw new IllegalArgumentException("Your input was neither an xls , nor an xlsx ");
    }

    public static DataIterator getExcelDataIterator(String configFile, InputStream is) throws Exception {
        return ImporterFactory.getExcelDataIterator(configFile, is, 0);
    }

    public static String getTextFileCharset(String file) throws IOException {
        byte[] head = new byte[3];
        try (FileInputStream is = null;){
            is = new FileInputStream(file);
            ((InputStream)is).read(head);
        }
        String code = "gb2312";
        if (head[0] == -1 && head[1] == -2) {
            code = "UTF-16";
        }
        if (head[0] == -2 && head[1] == -1) {
            code = "Unicode";
        }
        if (head[0] == -17 && head[1] == -69 && head[2] == -65) {
            code = "UTF-8";
        }
        return code;
    }
}

