/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.mdm.config.service.impl;

import com.biz.eisp.base.common.util.OConvertUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.mdm.config.bean.ExportExcelConfig;
import com.biz.eisp.mdm.config.entity.TmMdmTableConfigEntity;
import com.biz.eisp.mdm.config.service.DynamicExportFieldService;
import com.biz.eisp.mdm.config.util.DynamicConfigUtil;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="dynamicExportFieldService")
@Transactional
public class DefaultDynamicExportFieldServiceImpl
implements DynamicExportFieldService {
    @Override
    public ExportExcelConfig getExportExcelConfig(String tableName, String fieldName) {
        ExportExcelConfig exportExcelConfig = null;
        String tableConfigKey = String.valueOf(tableName) + fieldName;
        TmMdmTableConfigEntity configEntity = DynamicConfigUtil.allTableConfigByField.get(tableConfigKey.toLowerCase());
        if (StringUtil.isNotEmpty(configEntity)) {
            exportExcelConfig = new ExportExcelConfig();
            Integer isExport = configEntity.getImportOut();
            Integer columnOrder = StringUtil.isNotEmpty((String)configEntity.getColumnOrder()) ? Integer.parseInt(configEntity.getColumnOrder()) : 0;
            String exportName = StringUtil.isNotEmpty((String)configEntity.getFieldName()) ? configEntity.getFieldName() : configEntity.getColumnDesc();
            exportExcelConfig.setIsExport(OConvertUtils.getString(isExport));
            exportExcelConfig.setExportName(exportName);
            exportExcelConfig.setExprotOrder(OConvertUtils.getString(columnOrder));
            exportExcelConfig.setDictCode(configEntity.getDictType());
            System.out.println(String.valueOf(exportName) + ":" + columnOrder);
        } else {
            exportExcelConfig = null;
        }
        return exportExcelConfig;
    }

    @Override
    public boolean judgeIsExport(ExportExcelConfig exportExcelConfig) {
        if (!StringUtil.isNotEmpty(exportExcelConfig)) {
            return false;
        }
        if (StringUtil.isEmpty(exportExcelConfig.getIsExport())) {
            return false;
        }
        return !"0".equals(exportExcelConfig.getIsExport());
    }
}

