/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.mdm.custorg.service.impl;

import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.identity.IdEntity;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.ComboTree;
import com.biz.eisp.base.common.tag.bean.ComboTreeModel;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.common.util.TreeGridUtil;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;
import com.biz.eisp.mdm.config.util.DynamicConfigUtil;
import com.biz.eisp.mdm.custorg.dao.TmCustOrgDao;
import com.biz.eisp.mdm.custorg.entity.TmCustomerOrgEntity;
import com.biz.eisp.mdm.custorg.service.TmCustOrgExtendService;
import com.biz.eisp.mdm.custorg.service.TmCustOrgService;
import com.biz.eisp.mdm.custorg.transformer.TmCustomerOrgEntityToTmCustomerOrgVo;
import com.biz.eisp.mdm.custorg.transformer.TmCustomerOrgVoToTmCustomerEntity;
import com.biz.eisp.mdm.custorg.vo.QueryTmCustOrgVo;
import com.biz.eisp.mdm.custorg.vo.TmCustOrgBusinessVo;
import com.biz.eisp.mdm.custorg.vo.TmCustOrgCustomerVo;
import com.biz.eisp.mdm.custorg.vo.TmCustOrgTerminalVo;
import com.biz.eisp.mdm.custorg.vo.TmCustomerOrgVo;
import com.biz.eisp.mdm.dict.entity.TmDictDataEntity;
import com.biz.eisp.mdm.dict.service.TmDictDataService;
import com.biz.eisp.mdm.position.entity.TmPositionEntity;
import com.biz.eisp.mdm.position.service.TmPositionService;
import com.biz.eisp.mdm.user.entity.TmUserEntity;
import com.biz.eisp.mdm.user.service.TmUserService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="tmCustOrgService")
@Transactional
public class TmCustOrgServiceImpl
extends BaseServiceImpl
implements TmCustOrgService {
    @Autowired
    private TmCustOrgDao tmCustOrgDao;
    @Autowired
    private TmDictDataService tmDictDataService;
    @Autowired
    private TmPositionService tmPositionService;
    @Autowired
    private TmUserService tmUserService;
    @Autowired(required=false)
    private TmCustOrgExtendService tmCustOrgExtendService;

    @Override
    public TmCustomerOrgVo getTmCustOrg(String id) {
        TmCustomerOrgEntity entity = this.get(TmCustomerOrgEntity.class, (Serializable)((Object)id));
        TmCustomerOrgVo tmCustOrgVo = new TmCustomerOrgEntityToTmCustomerOrgVo(this).apply(entity);
        return tmCustOrgVo;
    }

    @Override
    public List<ComboTree> getParentCustOrg(HttpServletRequest request, ComboTree comboTree) {
        String selfId = request.getParameter("selfId");
        SimpleExpression cr = Restrictions.eq((String)"enableStatus", (Object)Globals.ZERO);
        List<Object> tmCustOrgList = new ArrayList();
        if (StringUtil.isNotEmpty((String)selfId)) {
            tmCustOrgList = this.findByProperty(TmCustomerOrgEntity.class, "id", selfId);
        } else if (StringUtil.isNotEmpty((String)comboTree.getId())) {
            SimpleExpression cr2 = Restrictions.eq((String)"tmCustOrg.id", (Object)comboTree.getId());
            tmCustOrgList = this.findByCriteria(TmCustomerOrgEntity.class, new Criterion[]{cr, cr2});
        } else {
            Criterion cr3 = Restrictions.isNull((String)"tmCustOrg.id");
            tmCustOrgList = this.findByCriteria(TmCustomerOrgEntity.class, new Criterion[]{cr, cr3});
        }
        ComboTreeModel comboTreeModel = new ComboTreeModel("id", "customerOrgName", "tmCustOrgs");
        List<ComboTree> comboTrees = this.comboTree(tmCustOrgList, comboTreeModel, null, false);
        return comboTrees;
    }

    @Override
    public void saveOrUpdateCustOrg(TmCustomerOrgVo custOrgVo, Page page) {
        IdEntity tmCustOrg = null;
        if (StringUtil.isNotEmpty(this.tmCustOrgExtendService)) {
            try {
                this.tmCustOrgExtendService.validate(custOrgVo, page);
            }
            catch (Exception e) {
                throw new BusinessException("\u9a8c\u8bc1\u6570\u636e\u5931\u8d25:" + e.getMessage());
            }
            tmCustOrg = this.tmCustOrgExtendService.saveBefore(custOrgVo, page);
        }
        if (StringUtil.isEmpty(tmCustOrg)) {
            tmCustOrg = new TmCustomerOrgVoToTmCustomerEntity(this).apply(custOrgVo);
        }
        if (StringUtil.isNotEmpty(this.tmCustOrgExtendService)) {
            tmCustOrg = this.tmCustOrgExtendService.saveBefore((TmCustomerOrgEntity)tmCustOrg, custOrgVo, page);
        }
        if (StringUtil.isNotEmpty((String)tmCustOrg.getId())) {
            List<TmCustomerOrgEntity> subCustOrg = this.findByProperty(TmCustomerOrgEntity.class, "tmCustOrg.id", tmCustOrg.getId());
            this.updateSubCustOrg(subCustOrg, (TmCustomerOrgEntity)tmCustOrg);
        }
        this.saveOrUpdate(tmCustOrg);
        if (StringUtil.isNotEmpty(this.tmCustOrgExtendService)) {
            tmCustOrg = this.tmCustOrgExtendService.savePost((TmCustomerOrgEntity)tmCustOrg, custOrgVo, page);
        }
    }

    private void updateSubCustOrg(List<TmCustomerOrgEntity> subCustOrg, TmCustomerOrgEntity parent) {
        if (subCustOrg.size() == 0) {
            return;
        }
        for (TmCustomerOrgEntity custOrg : subCustOrg) {
            custOrg.setCustOrgLevel(Integer.valueOf(String.valueOf(parent.getCustOrgLevel() + 1)));
            this.saveOrUpdate(custOrg);
            List<TmCustomerOrgEntity> subFunction1 = this.findByProperty(TmCustomerOrgEntity.class, "tmCustOrg.id", custOrg.getId());
            this.updateSubCustOrg(subFunction1, custOrg);
        }
    }

    @Override
    public AjaxJson delCustOrg(String ids) {
        String[] custOrgIds;
        AjaxJson j = new AjaxJson();
        String[] stringArray = custOrgIds = ids.split(",");
        int n = custOrgIds.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            TmCustomerOrgEntity orgEntity = this.get(TmCustomerOrgEntity.class, (Serializable)((Object)id));
            if (!StringUtil.isNotEmpty(orgEntity)) {
                j.setSuccess(false);
                j.setMsg("\u5220\u9664\u5931\u8d25\uff01");
                return j;
            }
            if (StringUtil.isNotEmpty(orgEntity.getTmCustOrgs()) && orgEntity.getTmCustOrgs().size() > 0) {
                j.setSuccess(false);
                j.setMsg("\u5220\u9664\u5931\u8d25\uff01\u3010" + orgEntity.getCustomerOrgName() + "\u3011\u4e0b\u9762\u5b50\u8282\u70b9\uff01");
                return j;
            }
            TmCustOrgTerminalVo tVo = new TmCustOrgTerminalVo();
            TmCustOrgCustomerVo cVo = new TmCustOrgCustomerVo();
            tVo.setCustOrgId(id);
            cVo.setCustOrgId(id);
            int a = this.tmCustOrgDao.findTmCustomerByCustOrg(cVo).size();
            int b = this.tmCustOrgDao.findTmTerminalByCustOrg(tVo).size();
            if (a > 0) {
                j.setSuccess(false);
                j.setMsg("\u6b64\u5ba2\u6237\u7ec4\u7ec7\u5173\u8054\u6709\u5ba2\u6237\u4e0d\u80fd\u5220\u9664\uff01");
                return j;
            }
            if (b > 0) {
                j.setSuccess(false);
                j.setMsg("\u6b64\u5ba2\u6237\u7ec4\u7ec7\u5173\u8054\u6709\u7ec8\u7aef\u4e0d\u80fd\u5220\u9664\uff01");
                return j;
            }
            orgEntity.setEnableStatus(Globals.ONE);
            this.updateEntity(orgEntity);
            ++n2;
        }
        j.setMsg("\u5220\u9664\u6210\u529f!");
        return j;
    }

    @Override
    public List<TmCustOrgCustomerVo> findTmCustomerByCustOrg(TmCustOrgCustomerVo tmCustOrgCustomerVo, Page page) {
        List<TmCustOrgCustomerVo> custorgcustvos = this.tmCustOrgDao.findTmCustomerByCustOrg(tmCustOrgCustomerVo, page);
        Iterator<TmCustOrgCustomerVo> iterator = custorgcustvos.iterator();
        while (iterator.hasNext()) {
            String sql = "select position_id from TM_R_CUST_POS_BG t where t.customer_id = ?";
            TmCustOrgCustomerVo tto = iterator.next();
            List<Map<String, Object>> positionList = this.findForMapList(sql, tto.getId());
            if (CollectionUtil.listEmpty(positionList)) continue;
            int i = 0;
            while (i < positionList.size()) {
                if (StringUtil.isNotEmpty(positionList.get(i).get("position_id"))) {
                    String positionId = (String)positionList.get(i).get("position_id");
                    TmPositionEntity tmPositionEntity = this.tmPositionService.get(TmPositionEntity.class, (Serializable)((Object)positionId));
                    tto.setPositionName(String.valueOf(StringUtil.isNotEmpty((String)tto.getPositionName()) ? String.valueOf(tto.getPositionName()) + "," : "") + tmPositionEntity.getPositionName());
                    String sql2 = "select user_id from TM_R_USER_POSITION t where t.position_id = ?";
                    List<Map<String, Object>> userList = this.findForMapList(sql2, positionId);
                    if (!CollectionUtil.listEmpty(userList)) {
                        int j = 0;
                        while (j < userList.size()) {
                            if (StringUtil.isNotEmpty(userList.get(j).get("user_id"))) {
                                String userID = (String)userList.get(j).get("user_id");
                                TmUserEntity tmUserEntity = this.tmUserService.get(TmUserEntity.class, (Serializable)((Object)userID));
                                tto.setUsername(String.valueOf(StringUtil.isNotEmpty((String)tto.getUsername()) ? String.valueOf(tto.getUsername()) + "," : "") + tmUserEntity.getFullName());
                            }
                            ++j;
                        }
                    }
                }
                ++i;
            }
        }
        return custorgcustvos;
    }

    @Override
    public TmDictDataEntity findDictDataByCode(String dictCode, String dictTypeCode) {
        return this.tmDictDataService.findByCode(dictCode, dictTypeCode);
    }

    @Override
    public List<TmCustOrgTerminalVo> findTmTerminalByCustOrg(TmCustOrgTerminalVo tmCustOrgTerminalVo, Page page) {
        return this.tmCustOrgDao.findTmTerminalByCustOrg(tmCustOrgTerminalVo, page);
    }

    @Override
    public List<TmCustOrgBusinessVo> findNotRefBusinessGrid(TmCustOrgBusinessVo tmCustOrgBusinessVo, Page page) {
        return this.tmCustOrgDao.findNotRefBusinessGrid(tmCustOrgBusinessVo, page);
    }

    @Override
    public List<TmCustOrgBusinessVo> findRefBusinessGrid(TmCustOrgBusinessVo tmCustOrgBusinessVo) {
        return this.tmCustOrgDao.findRefBusinessGrid(tmCustOrgBusinessVo);
    }

    @Override
    public List<ComboTree> getParentCustOrgs(HttpServletRequest request, ComboTree comboTree) {
        ComboTreeModel comboTreeModel;
        SimpleExpression cr = Restrictions.eq((String)"enableStatus", (Object)Globals.ZERO);
        List<Object> tmCustOrgList = new ArrayList();
        Object cr1 = null;
        String selfId = request.getParameter("selfId");
        if (StringUtil.isNotEmpty((String)selfId)) {
            tmCustOrgList = this.findByProperty(TmCustomerOrgEntity.class, "id", selfId);
        } else if (StringUtil.isNotEmpty((String)comboTree.getId())) {
            SimpleExpression cr2 = Restrictions.eq((String)"tmCustOrg.id", (Object)comboTree.getId());
            tmCustOrgList = this.findByCriteria(TmCustomerOrgEntity.class, new Criterion[]{cr, cr2});
        } else {
            Criterion cr3 = Restrictions.isNull((String)"tmCustOrg.id");
            tmCustOrgList = this.findByCriteria(TmCustomerOrgEntity.class, new Criterion[]{cr, cr3});
        }
        if (StringUtil.isNotEmpty((String)selfId)) {
            comboTreeModel = new ComboTreeModel("id", "customerOrgName", "tmCustOrgs");
            List<ComboTree> comboTrees = this.comboTree(tmCustOrgList, comboTreeModel, null, false);
            return comboTrees;
        }
        comboTreeModel = new ComboTreeModel("id", "customerOrgName", "tmCustOrgs");
        List<ComboTree> comboTrees = this.comboTree(tmCustOrgList, comboTreeModel, null, false);
        return comboTrees;
    }

    @Override
    public AjaxJson removeCustOrgBusiness(String id, String custOrgId) {
        AjaxJson j = new AjaxJson();
        if (StringUtil.isNotEmpty((String)id) && StringUtil.isNotEmpty((String)custOrgId)) {
            TmCustomerOrgEntity tmCustomerOrgEntity = null;
            tmCustomerOrgEntity = this.get(TmCustomerOrgEntity.class, (Serializable)((Object)custOrgId));
            if (StringUtil.isNotEmpty(tmCustomerOrgEntity)) {
                tmCustomerOrgEntity.setPositionId(null);
                this.saveOrUpdate(tmCustomerOrgEntity);
            } else {
                j.setMsg("\u79fb\u9664\u5931\u8d25");
                j.setSuccess(false);
            }
        } else {
            j.setMsg("\u79fb\u9664\u5931\u8d25");
            j.setSuccess(false);
        }
        return j;
    }

    @Override
    public AjaxJson addCustOrgBusiness(String id, String custOrgId) {
        AjaxJson j = new AjaxJson();
        if (StringUtil.isNotEmpty((String)id) && StringUtil.isNotEmpty((String)custOrgId)) {
            TmCustomerOrgEntity tmCustomerOrgEntity = null;
            tmCustomerOrgEntity = this.get(TmCustomerOrgEntity.class, (Serializable)((Object)custOrgId));
            if (StringUtil.isNotEmpty(tmCustomerOrgEntity)) {
                tmCustomerOrgEntity.setPositionId(id);
                this.saveOrUpdate(tmCustomerOrgEntity);
            } else {
                j.setMsg("\u6dfb\u52a0\u5931\u8d25");
                j.setSuccess(false);
            }
        } else {
            j.setMsg("\u6dfb\u52a0\u5931\u8d25");
            j.setSuccess(false);
        }
        return j;
    }

    @Override
    public List<TmCustomerOrgVo> findTmCustOrgByAllPossible(QueryTmCustOrgVo queryTmCustOrgVo, Page page) {
        return this.tmCustOrgDao.findTmCustOrgByAllPossible(queryTmCustOrgVo, page);
    }

    @Override
    public List<TmCustomerOrgVo> findTmCustomerOrgList(TmCustomerOrgVo custOrgVo) {
        String sql = DynamicConfigUtil.getInstance().buildTreeGridQuerySql(Globals.TABLE_CUSTOMER_ORG, custOrgVo);
        sql = String.valueOf(sql) + " order by to_number(regexp_substr(trim(t.cust_org_code),'[0-9]*[0-9]',1)) asc,length(t.cust_org_code) asc";
        List<TmCustomerOrgVo> voList = this.findBySql(TmCustomerOrgVo.class, sql, new Object[0]);
        if (DynamicConfigUtil.getInstance().isHaveQuery(Globals.TABLE_CUSTOMER_ORG, custOrgVo)) {
            voList = this.findQueryCustomerOrgList(custOrgVo, voList);
        }
        return voList;
    }

    private List<TmCustomerOrgVo> findQueryCustomerOrgList(TmCustomerOrgVo custOrgVo, List<TmCustomerOrgVo> voList) {
        if (custOrgVo.getExportExcel().equals("true")) {
            return voList;
        }
        List allQueryVolist = TreeGridUtil.buildTreeGrid(voList);
        return allQueryVolist;
    }

    private boolean hasQueryValue(TmCustomerOrgVo custOrgVo) {
        return !StringUtils.isBlank((CharSequence)custOrgVo.getCustOrgCode()) || !StringUtils.isBlank((CharSequence)custOrgVo.getCustomerOrgName()) || !StringUtils.isBlank((CharSequence)custOrgVo.getCustOrgType()) || !StringUtils.isBlank((CharSequence)custOrgVo.getCustOrgDesc()) || !StringUtils.isBlank((CharSequence)custOrgVo.getCustOrgType()) || !StringUtils.isBlank((CharSequence)custOrgVo.getExtChar1()) || !StringUtils.isBlank((CharSequence)custOrgVo.getExtChar2()) || !StringUtils.isBlank((CharSequence)custOrgVo.getExtChar3()) || !StringUtils.isBlank((CharSequence)custOrgVo.getExtChar4()) || !StringUtils.isBlank((CharSequence)custOrgVo.getExtChar5()) || custOrgVo.getExtNumber1() != null || custOrgVo.getExtNumber2() != null || custOrgVo.getExtNumber3() != null;
    }

    @Override
    public boolean validate(String id, String param, String fieldName) {
        SimpleExpression cr1 = Restrictions.eq((String)fieldName, (Object)param);
        List<Object> tmtbas = new ArrayList();
        if (StringUtil.isNotEmpty((String)id)) {
            SimpleExpression cr2 = Restrictions.ne((String)"id", (Object)id);
            tmtbas = this.findByCriteria(TmCustomerOrgEntity.class, new Criterion[]{cr1, cr2});
        } else {
            tmtbas = this.findByCriteria(TmCustomerOrgEntity.class, new Criterion[]{cr1});
        }
        return !CollectionUtils.isEmpty(tmtbas);
    }
}

