/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.login.controller;

import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.util.ContextHolderUtils;
import com.biz.eisp.base.common.util.OConvertUtils;
import com.biz.eisp.base.common.util.ResourceUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.web.BaseController;
import com.biz.eisp.login.service.JumpMainExtendService;
import com.biz.eisp.login.service.LoginService;
import com.biz.eisp.mdm.customer.entity.TmCustomerEntity;
import com.biz.eisp.mdm.function.service.MenuPermissionService;
import com.biz.eisp.mdm.function.vo.TmFunctionVo;
import com.biz.eisp.mdm.user.entity.TmUserEntity;
import com.biz.eisp.mdm.user.service.TmUserService;
import com.biz.eisp.mdm.user.vo.TmUserVo;
import com.biz.eisp.mdm.web.pojo.Client;
import com.biz.eisp.mdm.web.pojo.ClientManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/loginController"})
public class LoginController
extends BaseController {
    @Autowired
    private LoginService loginService;
    @Autowired
    private MenuPermissionService menuPermissionService;
    @Autowired
    private TmUserService tmUserService;
    @Autowired(required=false)
    private JumpMainExtendService jumpMainExtendService;

    @RequestMapping(params={"validateUser"})
    @ResponseBody
    public AjaxJson validateUser(TmUserEntity tmUserEntity, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        j.setMsg("\u9a8c\u8bc1\u6210\u529f");
        try {
            j = this.loginService.validateUser(tmUserEntity, Globals.N, Globals.N, request);
        }
        catch (Exception e) {
            j.setSuccess(false);
            j.setMsg("\u670d\u52a1\u5668\u5f02\u5e38");
            e.printStackTrace();
            throw new BusinessException("\u767b\u5f55\u5931\u8d25\uff0c\u670d\u52a1\u5668\u5f02\u5e38");
        }
        return j;
    }

    @RequestMapping(params={"login"})
    public ModelAndView login(TmUserEntity tmUserEntity, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        ModelAndView modelAndView = new ModelAndView();
        try {
            if (StringUtils.isEmpty((String)tmUserEntity.getUserName()) || StringUtils.isEmpty((String)tmUserEntity.getPassword())) {
                modelAndView.setViewName("login/login");
                return modelAndView;
            }
            j = this.loginService.validateUser(tmUserEntity, Globals.Y, Globals.N, request);
            if (j.isSuccess()) {
                HttpSession session = ContextHolderUtils.getSession();
                request.getSession().setAttribute("sessionId", (Object)session.getId());
                TmUserVo userVo = new TmUserVo();
                userVo.setUserName(tmUserEntity.getUserName());
                userVo = this.tmUserService.getTmUser(userVo);
                if (this.hasFirstChangePwdView(userVo) && !"admin".equalsIgnoreCase(userVo.getUserName())) {
                    modelAndView.setViewName("login/loginFirst");
                    modelAndView.addObject("tmUserVo", (Object)userVo);
                    return modelAndView;
                }
                if (userVo.getUserType() == Globals.CUST_USER) {
                    if (StringUtils.isNotBlank((String)userVo.getCustCode())) {
                        TmCustomerEntity customerEntity = new TmCustomerEntity();
                        customerEntity.setId(userVo.getCustId());
                        customerEntity.setCustomerCode(userVo.getCustCode());
                        customerEntity.setErpCode(userVo.getErpCode());
                        customerEntity.setCustomerName(userVo.getCustName());
                        Client client = ClientManager.getInstance().getClient();
                        client.setCustomerEntity(customerEntity);
                        ClientManager.getInstance().addClinet(ContextHolderUtils.getSession().getId(), client);
                        String customerIndexPage = ResourceUtil.getSysConfigProperty("customerIndexPage");
                        request.setAttribute("customer", (Object)customerEntity);
                        modelAndView.setViewName(StringUtils.isNotBlank((String)customerIndexPage) ? customerIndexPage : "login/errorCustomerIndex");
                    } else {
                        modelAndView.setViewName("login/login");
                    }
                } else {
                    if (StringUtil.isNotEmpty(this.jumpMainExtendService)) {
                        this.jumpMainExtendService.beforeJumpMain(tmUserEntity, userVo);
                    }
                    request.setAttribute("userVo", (Object)userVo);
                    modelAndView.setViewName("main/main");
                }
                return modelAndView;
            }
            modelAndView.setViewName("login/login");
            return modelAndView;
        }
        catch (Exception e) {
            modelAndView.setViewName("login/login");
            return modelAndView;
        }
    }

    @RequestMapping(params={"apiLogin"})
    public ModelAndView apiLogin(TmUserEntity tmUserEntity, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        ModelAndView modelAndView = new ModelAndView();
        String isEncryption = OConvertUtils.getString(request.getParameter("isEncryption"));
        if (StringUtil.isEmpty(isEncryption)) {
            isEncryption = Globals.N;
        }
        try {
            if (StringUtils.isEmpty((String)tmUserEntity.getUserName()) || StringUtils.isEmpty((String)tmUserEntity.getPassword())) {
                modelAndView.setViewName("login/login");
                return modelAndView;
            }
            j = this.loginService.validateUser(tmUserEntity, Globals.Y, isEncryption, request);
            if (j.isSuccess()) {
                HttpSession session = ContextHolderUtils.getSession();
                request.getSession().setAttribute("sessionId", (Object)session.getId());
                TmUserVo userVo = new TmUserVo();
                userVo.setUserName(tmUserEntity.getUserName());
                userVo = this.tmUserService.getTmUser(userVo);
                if (this.hasFirstChangePwdView(userVo) && !"admin".equalsIgnoreCase(userVo.getUserName())) {
                    modelAndView.setViewName("login/loginFirst");
                    modelAndView.addObject("tmUserVo", (Object)userVo);
                    return modelAndView;
                }
                if (userVo.getUserType() == Globals.CUST_USER) {
                    if (StringUtils.isNotBlank((String)userVo.getCustCode())) {
                        TmCustomerEntity customerEntity = new TmCustomerEntity();
                        customerEntity.setId(userVo.getCustId());
                        customerEntity.setCustomerCode(userVo.getCustCode());
                        customerEntity.setErpCode(userVo.getErpCode());
                        customerEntity.setCustomerName(userVo.getCustName());
                        Client client = ClientManager.getInstance().getClient();
                        client.setCustomerEntity(customerEntity);
                        ClientManager.getInstance().addClinet(ContextHolderUtils.getSession().getId(), client);
                        String customerIndexPage = ResourceUtil.getSysConfigProperty("customerIndexPage");
                        request.setAttribute("customer", (Object)customerEntity);
                        modelAndView.setViewName(StringUtils.isNotBlank((String)customerIndexPage) ? customerIndexPage : "login/errorCustomerIndex");
                    } else {
                        modelAndView.setViewName("login/login");
                    }
                } else {
                    if (StringUtil.isNotEmpty(this.jumpMainExtendService)) {
                        this.jumpMainExtendService.beforeJumpMain(tmUserEntity, userVo);
                    }
                    request.setAttribute("userVo", (Object)userVo);
                    modelAndView.setViewName("main/main");
                }
                return modelAndView;
            }
            modelAndView.setViewName("login/login");
            return modelAndView;
        }
        catch (Exception e) {
            modelAndView.setViewName("login/login");
            return modelAndView;
        }
    }

    private boolean hasFirstChangePwdView(TmUserVo tmUserVo) {
        String hasFirstTimeChange = ResourceUtil.getSysConfigProperty("hasFirstTimeChange");
        return StringUtil.isNotEmpty((String)hasFirstTimeChange) && hasFirstTimeChange.equalsIgnoreCase("enable") && (StringUtil.isEmpty(tmUserVo.getHasFirstTime()) || StringUtil.isNotEmpty(tmUserVo.getHasFirstTime()) && tmUserVo.getHasFirstTime() == 1);
    }

    @RequestMapping(params={"left"})
    public ModelAndView left(HttpServletRequest request) {
        HttpSession session = ContextHolderUtils.getSession();
        Client client = ClientManager.getInstance().getClient(session.getId());
        TmUserEntity tmUserEntity = client.getUser();
        ModelAndView modelAndView = new ModelAndView();
        if (tmUserEntity.getId() == null) {
            session.removeAttribute(Globals.USER_SESSION);
            modelAndView.setViewName("login/login");
        } else {
            request.setAttribute("menuPermissionMap", this.getFunctionLevelMap(tmUserEntity));
            modelAndView.setViewName("main/left");
        }
        return modelAndView;
    }

    private Map<Integer, List<TmFunctionVo>> getFunctionLevelMap(TmUserEntity tmUserEntity) {
        HashMap<Integer, List<TmFunctionVo>> functionMap = new HashMap<Integer, List<TmFunctionVo>>();
        Map<String, TmFunctionVo> functionsMap = this.getFucntionsByUser(tmUserEntity);
        if (functionsMap.size() > 0) {
            Collection<TmFunctionVo> allFunctions = functionsMap.values();
            for (TmFunctionVo function : allFunctions) {
                if (!functionMap.containsKey(function.getFunctionLevel() + 0)) {
                    functionMap.put(function.getFunctionLevel() + 0, new ArrayList());
                }
                ((List)functionMap.get(function.getFunctionLevel() + 0)).add(function);
            }
            Collection tmFunction = functionMap.values();
            for (List list : tmFunction) {
                Collections.sort(list);
            }
        }
        return functionMap;
    }

    private Map<String, TmFunctionVo> getFucntionsByUser(TmUserEntity tmUserEntity) {
        HashMap<String, TmFunctionVo> map = new HashMap<String, TmFunctionVo>();
        HttpSession session = ContextHolderUtils.getSession();
        ClientManager clientManager = ClientManager.getInstance();
        Client client = clientManager.getClient(session.getId());
        if (client.getFunctions() != null && client.getFunctions().size() > 0) {
            map.putAll(client.getFunctions());
        } else {
            List<TmFunctionVo> tmFunctions = this.menuPermissionService.getFunctionsByUser(tmUserEntity);
            if (tmFunctions.size() > 0) {
                for (TmFunctionVo tmFunctionVo : tmFunctions) {
                    map.put(tmFunctionVo.getId(), tmFunctionVo);
                }
            }
        }
        return map;
    }

    @RequestMapping(params={"home"})
    public ModelAndView home(HttpServletRequest request) {
        return new ModelAndView("main/home");
    }

    @RequestMapping(params={"noPermisson"})
    public ModelAndView noPermisson(HttpServletRequest request) {
        return new ModelAndView("common/noPermisson");
    }

    @RequestMapping(params={"nonLoginAccess"})
    public ModelAndView nonLoginAccess(HttpServletRequest request) {
        ModelAndView modelAndView = new ModelAndView();
        TmUserEntity tmUserEntity = new TmUserEntity();
        tmUserEntity.setUserName("admin");
        tmUserEntity.setPassword("123456");
        AjaxJson j = this.loginService.validateUser(tmUserEntity, Globals.Y, Globals.N, request);
        HttpSession session = ContextHolderUtils.getSession();
        request.getSession().setAttribute("sessionId", (Object)session.getId());
        TmUserVo userVo = new TmUserVo();
        userVo.setUserName(tmUserEntity.getUserName());
        userVo = this.tmUserService.getTmUser(userVo);
        request.setAttribute("userVo", (Object)userVo);
        modelAndView.setViewName("main/main");
        return modelAndView;
    }

    @RequestMapping(params={"logout"})
    public ModelAndView logout(HttpServletRequest request) {
        ClientManager clientManager = ClientManager.getInstance();
        HttpSession session = ContextHolderUtils.getSession();
        TmUserEntity user = ResourceUtil.getSessionUserName();
        clientManager.removeUserNameSessionIdMap(user.getUserName());
        clientManager.removeClinet(session.getId());
        return new ModelAndView("login/login");
    }
}

