/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.activiti.runtime.controller;

import com.biz.eisp.activiti.common.WorkFlowGlobals;
import com.biz.eisp.activiti.designer.processconf.service.TaProcessService;
import com.biz.eisp.activiti.designer.processconf.vo.TaProcessVo;
import com.biz.eisp.activiti.runtime.service.TaCarbonCopyService;
import com.biz.eisp.activiti.runtime.service.TaHandCopyAndCirculationService;
import com.biz.eisp.activiti.runtime.service.TaTaskService;
import com.biz.eisp.activiti.runtime.vo.MyTaskVo;
import com.biz.eisp.activiti.runtime.vo.TaCarbonCopyVo;
import com.biz.eisp.activiti.runtime.vo.TaCopyCirculationVo;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.util.ResourceUtil;
import com.biz.eisp.base.core.page.EuPage;
import com.biz.eisp.mdm.actrole.service.TmActRoleService;
import com.biz.eisp.mdm.actrole.vo.TmActRoleVo;
import com.biz.eisp.mdm.position.service.TmPositionService;
import com.biz.eisp.mdm.position.vo.TmPositionVo;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.Task;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/taCarbonCopyController"})
public class TaCarbonCopyController {
    @Autowired
    private TaCarbonCopyService taCarbonCopyService;
    @Autowired(required=false)
    private RepositoryService repositoryService;
    @Autowired
    private TaskService taskService;
    @Autowired
    private TaProcessService taProcessService;
    @Autowired
    private TmPositionService tmPositionService;
    @Autowired
    private TmActRoleService tmActRoleService;
    @Autowired
    private TaTaskService taTaskService;
    @Autowired
    private TaHandCopyAndCirculationService taHandCopyAndCirculationService;
    @Autowired
    private RuntimeService runtimeService;

    @RequestMapping(params={"goAddCarbonCopyMain"})
    public ModelAndView goAddCarbonCopyMain(String id) {
        ModelAndView view = new ModelAndView("com/biz/eisp/activiti/runtime/carbonCopyMain");
        view.addObject("taProcessId", (Object)id);
        return view;
    }

    @RequestMapping(params={"getRolesOrPositions"})
    @ResponseBody
    public DataGrid getRolesOrPositions(String sendType, TmPositionVo vo, String roleName, String roleCode, HttpServletRequest request) {
        EuPage page = new EuPage(request);
        DataGrid dataGrid = null;
        if (sendType != null && "0".equals(sendType) || "".equals(sendType)) {
            TmActRoleVo query = new TmActRoleVo();
            query.setRoleName(roleName);
            query.setRoleCode(roleCode);
            List<TmActRoleVo> roles = this.tmActRoleService.findActRoleMain(query, page);
            dataGrid = new DataGrid(roles, page);
        } else if (sendType != null && sendType.equals("1")) {
            TmPositionVo query = new TmPositionVo();
            if (!"-1".equals(vo.getOrgId()) && vo.getOrgId() != null) {
                query.setOrgId(vo.getOrgId());
            }
            query.setPositionName(vo.getPositionName());
            query.setPositionCode(vo.getPositionCode());
            query.setFullName(vo.getFullName());
            List<TmPositionVo> positions = this.tmPositionService.findPositionByConditions(query, page);
            dataGrid = new DataGrid(positions, page);
        }
        return dataGrid;
    }

    @RequestMapping(params={"saveCarbonCopy"})
    @ResponseBody
    public AjaxJson saveCarbonCopy(TaCarbonCopyVo vo) {
        AjaxJson aj = new AjaxJson();
        try {
            aj = this.taCarbonCopyService.saveCarbonCopy(vo);
        }
        catch (Exception e) {
            aj.setSuccess(false);
            aj.setMsg("\u4fdd\u5b58\u5931\u8d25");
            e.printStackTrace();
        }
        return aj;
    }

    @RequestMapping(params={"findCarbonCopyByTaProcessId"})
    @ResponseBody
    public DataGrid findCarbonCopyByTaProcessId(TaCarbonCopyVo taCarbonCopyVo, HttpServletRequest request) {
        EuPage page = new EuPage(request);
        List<TaCarbonCopyVo> result = this.taCarbonCopyService.findTaCarbonCopy(taCarbonCopyVo, page);
        return new DataGrid(result, page);
    }

    @RequestMapping(params={"delCarbonCopyById"})
    @ResponseBody
    public AjaxJson delCarbonCopyById(String delIds) {
        AjaxJson aj = new AjaxJson();
        try {
            this.taCarbonCopyService.delCarbonCopyById(delIds);
        }
        catch (Exception e) {
            aj.setSuccess(false);
            aj.setMsg("\u6570\u636e\u5e93\u53d1\u751f\u5f02\u5e38");
            e.printStackTrace();
        }
        return aj;
    }

    @RequestMapping(params={"findHomeCarbonCopyList"})
    @ResponseBody
    public DataGrid findHomeCarbonCopyList(TaCopyCirculationVo vo, String time, HttpServletRequest request) {
        EuPage page = new EuPage(request);
        vo.setCreateDate(time);
        List<TaCopyCirculationVo> result = this.taCarbonCopyService.findCopyAndCirculation(vo, page);
        return new DataGrid(result, page);
    }

    @RequestMapping(params={"goCarbonCopyMain"})
    public ModelAndView goCarbonCopyMain() {
        ModelAndView view = new ModelAndView("com/biz/eisp/activiti/runtime/taMyCarbonCopy");
        return view;
    }

    @RequestMapping(params={"findCarbonCopyList"})
    @ResponseBody
    public DataGrid findCarbonCopyList(TaCopyCirculationVo vo, HttpServletRequest request) {
        EuPage page = new EuPage(request);
        List<TaCopyCirculationVo> result = this.taCarbonCopyService.getCarbonCopyByConditions(vo, page);
        return new DataGrid(result, page);
    }

    @RequestMapping(params={"goAddCirculationMain"})
    public ModelAndView goAddCirculationMain(String taskId) {
        ModelAndView view = new ModelAndView("com/biz/eisp/activiti/runtime/circulationMain");
        Task task = (Task)this.taskService.createTaskQuery().taskId(taskId).singleResult();
        ProcessDefinition pd = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionId(task.getProcessDefinitionId()).singleResult();
        TaProcessVo processVo = this.taProcessService.findProcessByKey(pd.getKey());
        view.addObject("taProcessId", (Object)processVo.getId());
        view.addObject("taskId", (Object)taskId);
        return view;
    }

    @RequestMapping(params={"saveCirculation"})
    @ResponseBody
    public AjaxJson saveCirculation(String taskId, String codes, String names, String fullNames, String content) {
        AjaxJson aj = new AjaxJson();
        try {
            this.taCarbonCopyService.saveCirculation(taskId, codes, names, fullNames, content);
        }
        catch (Exception e) {
            aj.setSuccess(false);
            aj.setMsg("\u64cd\u4f5c\u5931\u8d25:\u5b57\u6570\u8d85\u957f,\u6700\u957f250\u4e2a");
            e.printStackTrace();
        }
        return aj;
    }

    @RequestMapping(params={"saveCirculationContent"})
    @ResponseBody
    public AjaxJson saveCirculationContent(String id, String content) {
        AjaxJson aj = new AjaxJson();
        try {
            this.taHandCopyAndCirculationService.saveCirculationContent(id, content);
        }
        catch (Exception e) {
            aj.setSuccess(false);
            aj.setMsg("\u6570\u636e\u5e93\u64cd\u4f5c\u53d1\u751f\u5f02\u5e38");
            e.printStackTrace();
        }
        return aj;
    }

    @RequestMapping(params={"goCopyAndCirculationTabs"})
    public ModelAndView goCopyAndCirculationTabs(TaCopyCirculationVo vo) {
        ModelAndView view = new ModelAndView("com/biz/eisp/activiti/runtime/copyAndCirculationTab");
        view.addObject("query", (Object)vo);
        return view;
    }

    @RequestMapping(params={"updateCarbonOrCirculationState"})
    @ResponseBody
    public AjaxJson updateCarbonOrCirculationState(TaCopyCirculationVo vo) {
        AjaxJson aj = new AjaxJson();
        try {
            this.taHandCopyAndCirculationService.updateCarbonOrCirculationState(vo);
        }
        catch (Exception e) {
            aj.setSuccess(false);
            aj.setMsg(e.getMessage());
        }
        return aj;
    }

    @RequestMapping(params={"goCopyAndCirculationBusiness"})
    public ModelAndView goCopyAndCirculationBusiness(String businessKey, String processInstanceId, HttpServletRequest request) {
        ModelAndView view = new ModelAndView("com/biz/eisp/activiti/runtime/copyAndCirculationBusinessForm");
        MyTaskVo queryVo = new MyTaskVo();
        queryVo.setProcessInstanceId(processInstanceId);
        this.taTaskService.findProcessBasicInfoByProcinstId(queryVo, request);
        this.taTaskService.findAttachmentListByProcinstId(processInstanceId, request);
        return view;
    }

    @RequestMapping(params={"goCopyAndCirculationTaskForm"})
    public ModelAndView goCopyAndCirculationTaskForm(TaCopyCirculationVo vo, HttpServletRequest request) {
        ModelAndView view = null;
        TaCopyCirculationVo queryVo = new TaCopyCirculationVo();
        List<TaCopyCirculationVo> result = null;
        if ("0".equals(vo.getInOut())) {
            view = new ModelAndView("com/biz/eisp/activiti/runtime/taCirculationOperateInForm");
            queryVo.setId(vo.getId());
            queryVo.setQueryCode(ResourceUtil.getCurrPosition().getPositionCode());
            result = this.taHandCopyAndCirculationService.findCirculationMessage(queryVo);
            String isReply = "0";
            for (TaCopyCirculationVo v : result) {
                if (!"1".equals(v.getIsReply())) continue;
                isReply = "1";
                break;
            }
            view.addObject("isReply", (Object)isReply);
        } else if ("1".equals(vo.getInOut())) {
            view = new ModelAndView("com/biz/eisp/activiti/runtime/taCirculationOperateOutForm");
            queryVo.setId(vo.getId());
            queryVo.setContentId(vo.getContentId());
            result = this.taHandCopyAndCirculationService.findCirculationMessage(queryVo);
        }
        String piId = vo.getProcessInstanceId();
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(piId).singleResult();
        if (processInstance == null) {
            view.addObject("taskState", (Object)0);
        } else {
            view.addObject("taskState", (Object)1);
        }
        view.addObject("content", result);
        view.addObject("inOut", (Object)vo.getInOut());
        return view;
    }

    @RequestMapping(params={"goCopyOrCirculationOperateForm"})
    public ModelAndView goCopyOrCirculationOperateForm(TaCopyCirculationVo vo, HttpServletRequest request) {
        ModelAndView view = new ModelAndView("com/biz/eisp/activiti/runtime/copyOperateForm");
        request.setAttribute("processInstanceId", (Object)vo.getProcessInstanceId());
        this.setKeyIndicators(vo.getProcessInstanceId(), request);
        MyTaskVo taskVo = new MyTaskVo();
        taskVo.setProcessInstanceId(vo.getProcessInstanceId());
        this.taTaskService.findApprovalLogs(taskVo, request);
        return view;
    }

    private void setKeyIndicators(String processInstanceId, HttpServletRequest request) {
        String modelAndView = this.taTaskService.getProcessInstanceBusinessForm(processInstanceId);
        if (modelAndView != null) {
            modelAndView = modelAndView + "&isKeyIndicators=true";
        }
        request.setAttribute(WorkFlowGlobals.PROCNODE_START, (Object)modelAndView);
    }
}

