/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.common.util;

import com.biz.eisp.base.common.util.ReflectHelper;
import com.biz.eisp.base.common.util.StringUtil;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import jodd.bean.BeanTool;
import jodd.bean.BeanUtil;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.commons.beanutils.PropertyUtils;

public class MyBeanUtils
extends BeanUtils {
    private static void convert(Object dest, Object orig) throws IllegalAccessException, InvocationTargetException {
        if (dest == null) {
            throw new IllegalArgumentException("No destination bean specified");
        }
        if (orig == null) {
            throw new IllegalArgumentException("No origin bean specified");
        }
        if (orig instanceof DynaBean) {
            DynaProperty[] origDescriptors = ((DynaBean)orig).getDynaClass().getDynaProperties();
            for (int i = 0; i < origDescriptors.length; ++i) {
                String name = origDescriptors[i].getName();
                if (!PropertyUtils.isWriteable((Object)dest, (String)name)) continue;
                Object value = ((DynaBean)orig).get(name);
                try {
                    MyBeanUtils.copyProperty((Object)dest, (String)name, (Object)value);
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        } else if (orig instanceof Map) {
            for (String name : ((Map)orig).keySet()) {
                if (!PropertyUtils.isWriteable((Object)dest, (String)name)) continue;
                Object value = ((Map)orig).get(name);
                try {
                    MyBeanUtils.copyProperty((Object)dest, (String)name, value);
                }
                catch (Exception e) {}
            }
        } else {
            PropertyDescriptor[] origDescriptors = PropertyUtils.getPropertyDescriptors((Object)orig);
            for (int i = 0; i < origDescriptors.length; ++i) {
                String name = origDescriptors[i].getName();
                if ("class".equals(name) || !PropertyUtils.isReadable((Object)orig, (String)name) || !PropertyUtils.isWriteable((Object)dest, (String)name)) continue;
                try {
                    Object value = PropertyUtils.getSimpleProperty((Object)orig, (String)name);
                    MyBeanUtils.copyProperty((Object)dest, (String)name, (Object)value);
                    continue;
                }
                catch (IllegalArgumentException ie) {
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
    }

    public static void copyBeanNotNull2Bean(Object databean, Object tobean) throws Exception {
        PropertyDescriptor[] origDescriptors = PropertyUtils.getPropertyDescriptors((Object)databean);
        for (int i = 0; i < origDescriptors.length; ++i) {
            String name = origDescriptors[i].getName();
            if ("class".equals(name) || !PropertyUtils.isReadable((Object)databean, (String)name) || !PropertyUtils.isWriteable((Object)tobean, (String)name)) continue;
            try {
                Object value = PropertyUtils.getSimpleProperty((Object)databean, (String)name);
                if (!StringUtil.isNotEmpty(value)) continue;
                MyBeanUtils.copyProperty((Object)tobean, (String)name, (Object)value);
                continue;
            }
            catch (IllegalArgumentException ie) {
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public static void copyBean2Bean(Object dest, Object orig) throws Exception {
        MyBeanUtils.convert(dest, orig);
    }

    public static void copyBean2Map(Map map, Object bean) {
        PropertyDescriptor[] pds = PropertyUtils.getPropertyDescriptors((Object)bean);
        for (int i = 0; i < pds.length; ++i) {
            PropertyDescriptor pd = pds[i];
            String propname = pd.getName();
            try {
                Object propvalue = PropertyUtils.getSimpleProperty((Object)bean, (String)propname);
                map.put(propname, propvalue);
                continue;
            }
            catch (IllegalAccessException e) {
                continue;
            }
            catch (InvocationTargetException e) {
                continue;
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
    }

    public static void copyMap2Bean(Object bean, Map properties) throws IllegalAccessException, InvocationTargetException {
        if (bean == null || properties == null) {
            return;
        }
        for (String name : properties.keySet()) {
            if (name == null) continue;
            Object value = properties.get(name);
            try {
                String className;
                Class clazz = PropertyUtils.getPropertyType((Object)bean, (String)name);
                if (null == clazz || (className = clazz.getName()).equalsIgnoreCase("java.sql.Timestamp") && (value == null || value.equals("")) || className.equalsIgnoreCase("java.math.BigDecimal") && (value == null || value.equals(""))) continue;
                MyBeanUtils.setProperty((Object)bean, (String)name, value);
            }
            catch (NoSuchMethodException e) {}
        }
    }

    public static void copyMap2BeanReflect(Object bean, Map properties) throws Exception {
        if (bean == null || properties == null) {
            return;
        }
        Iterator names = properties.keySet().iterator();
        while (names.hasNext()) {
            ReflectHelper reflectHelper = new ReflectHelper(bean);
            String name = (String)names.next();
            if (name == null) continue;
            try {
                Object value = properties.get(name);
                reflectHelper.setMethodValue(name, value);
            }
            catch (Exception e) {}
        }
    }

    public static void copyMap2Bean_Nobig(Object bean, Map properties) throws IllegalAccessException, InvocationTargetException {
        if (bean == null || properties == null) {
            return;
        }
        for (String name : properties.keySet()) {
            if (name == null) continue;
            Object value = properties.get(name);
            try {
                Class clazz;
                if (value == null || null == (clazz = PropertyUtils.getPropertyType((Object)bean, (String)name))) continue;
                String className = clazz.getName();
                if (className.equalsIgnoreCase("java.util.Date")) {
                    value = new Date(((Timestamp)value).getTime());
                }
                MyBeanUtils.setProperty((Object)bean, (String)name, value);
            }
            catch (NoSuchMethodException e) {}
        }
    }

    public static void copyMap2Bean(Object bean, Map properties, String defaultValue) throws IllegalAccessException, InvocationTargetException {
        if (bean == null || properties == null) {
            return;
        }
        for (String name : properties.keySet()) {
            if (name == null) continue;
            Object value = properties.get(name);
            try {
                String className;
                Class clazz = PropertyUtils.getPropertyType((Object)bean, (String)name);
                if (null == clazz || (className = clazz.getName()).equalsIgnoreCase("java.sql.Timestamp") && (value == null || value.equals(""))) continue;
                if (className.equalsIgnoreCase("java.lang.String") && value == null) {
                    value = defaultValue;
                }
                MyBeanUtils.setProperty((Object)bean, (String)name, value);
            }
            catch (NoSuchMethodException e) {}
        }
    }

    public static void apply(Object srcBean, Object dstBean) {
        MyBeanUtils.copy(srcBean, dstBean, null, null, null, false);
    }

    public static void sepecialCopy(Object srcBean, Object dstBean, Collection<String> ignoredProps) {
        MyBeanUtils.copy(srcBean, dstBean, null, ignoredProps, null, true);
    }

    private static void copy(Object srcBean, Object dstBean, Map<String, String> revertMap, Collection<String> ignoredProps, Collection<String> props, boolean copyNull) {
        String[] properties;
        for (String property : properties = BeanTool.resolveProperties((Object)dstBean, (boolean)true)) {
            Object value;
            String srcPropName;
            if (props != null && !props.contains(property) || ignoredProps != null && ignoredProps.contains(property)) continue;
            if (revertMap != null) {
                srcPropName = revertMap.get(property);
                if (srcPropName == null) {
                    srcPropName = property;
                }
            } else {
                srcPropName = property;
            }
            if ((value = BeanUtil.getPropertySilently((Object)srcBean, (String)srcPropName)) == null && !copyNull) continue;
            BeanUtil.setPropertySilent((Object)dstBean, (String)property, (Object)value);
        }
    }
}

