/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.common.util;

import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.ContextHolderUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.service.BaseService;
import com.biz.eisp.base.utils.ApplicationContextUtils;
import com.biz.eisp.mdm.config.util.DBTypeUtil;
import com.biz.eisp.mdm.customer.entity.TmCustomerEntity;
import com.biz.eisp.mdm.custorg.entity.TmCustomerOrgEntity;
import com.biz.eisp.mdm.org.entity.TmOrgEntity;
import com.biz.eisp.mdm.org.service.TmOrgService;
import com.biz.eisp.mdm.position.vo.TmPositionVo;
import com.biz.eisp.mdm.role.vo.TmRoleVo;
import com.biz.eisp.mdm.user.entity.TmUserEntity;
import com.biz.eisp.mdm.user.service.TmUserService;
import com.biz.eisp.mdm.user.vo.TmUserVo;
import com.biz.eisp.mdm.web.pojo.Client;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class ResourceUtil {
    public static String getRequestPath(HttpServletRequest request) {
        String requestPath = request.getRequestURI() + "?" + request.getQueryString();
        if (requestPath.indexOf("&") > -1) {
            requestPath = requestPath.substring(0, requestPath.indexOf("&"));
        }
        requestPath = requestPath.substring(request.getContextPath().length() + 1);
        return requestPath;
    }

    public static String getParameter(String field) {
        HttpServletRequest request = ContextHolderUtils.getRequest();
        return request.getParameter(field);
    }

    public static final TmUserEntity getSessionUserName() {
        Client client;
        HttpSession session = ContextHolderUtils.getSession();
        Object ob = session.getAttribute(session.getId());
        if (ob != null && (client = (Client)ob) != null) {
            return client.getUser();
        }
        return null;
    }

    public static final TmCustomerEntity getSessionCustomer() {
        Client client;
        HttpSession session = ContextHolderUtils.getSession();
        Object ob = session.getAttribute(session.getId());
        if (ob != null && (client = (Client)ob) != null) {
            return client.getCustomerEntity();
        }
        return null;
    }

    public static final TmPositionVo getCurrPosition() {
        Client client;
        HttpSession session = ContextHolderUtils.getSession();
        Object ob = session.getAttribute(session.getId());
        if (ob != null && (client = (Client)ob) != null) {
            return client.getPosition();
        }
        return null;
    }

    public static final TmOrgEntity getCurrOrg() {
        Client client;
        HttpSession session = ContextHolderUtils.getSession();
        Object ob = session.getAttribute(session.getId());
        if (ob != null && (client = (Client)ob) != null) {
            return client.getOrg();
        }
        return null;
    }

    public static final TmOrgEntity getCurrOrgByType(String orgType) {
        Client client;
        HttpSession session = ContextHolderUtils.getSession();
        Object ob = session.getAttribute(session.getId());
        if (ob != null && (client = (Client)ob) != null) {
            String sql;
            String currOrgId = client.getOrg().getId();
            TmOrgService tmOrgService = (TmOrgService)ApplicationContextUtils.getContext().getBean("tmOrgService");
            List<Map<String, Object>> mapList = tmOrgService.findForMapList(sql = "select t.id from tm_org t where t.org_type = ?  start with t.id = ? connect by id = prior parent_id", orgType, currOrgId);
            if (CollectionUtil.listNotEmptyNotSizeZero(mapList)) {
                return tmOrgService.get(TmOrgEntity.class, (Serializable)((Object)((String)mapList.get(0).get("id"))));
            }
        }
        return new TmOrgEntity();
    }

    public static final TmCustomerOrgEntity getCurrCustomerOrg() {
        Client client;
        HttpSession session = ContextHolderUtils.getSession();
        Object ob = session.getAttribute(session.getId());
        if (ob != null && (client = (Client)ob) != null) {
            return client.getCustomerOrg();
        }
        return null;
    }

    public static TmUserVo getSessionTmUserVo() {
        TmUserService tmUserService = (TmUserService)ApplicationContextUtils.getContext().getBean("tmUserService");
        TmUserEntity tmUserEntity = ResourceUtil.getSessionUserName();
        TmUserVo tmUserVo = new TmUserVo();
        tmUserVo.setUserName(tmUserEntity.getUserName());
        return tmUserService.getTmUser(tmUserVo);
    }

    public static List<TmUserVo> getSessionTmUserList() {
        TmUserService tmUserService = (TmUserService)ApplicationContextUtils.getContext().getBean("tmUserService");
        TmUserEntity tmUserEntity = ResourceUtil.getSessionUserName();
        TmUserVo tmUserVo = new TmUserVo();
        tmUserVo.setUserName(tmUserEntity.getUserName());
        return tmUserService.getTmUserList(tmUserVo);
    }

    public static final String getTmRoleString() {
        if (StringUtil.isNotEmpty(ResourceUtil.getCurrPosition())) {
            BaseService baseService = (BaseService)ApplicationContextUtils.getContext().getBean("baseService");
            String positionId = ResourceUtil.getCurrPosition().getId();
            StringBuffer roleBuffer = new StringBuffer();
            String sql = "SELECT TR.ROLE_NAME AS roleName,TR.ROLE_CODE AS roleCode,TR.ID AS id FROM TM_ROLE TR JOIN TM_R_POSITION_ROLE TRPR ON TR.ID=TRPR.ROLE_ID  WHERE TRPR.POSITION_ID = ?";
            List<TmRoleVo> tmRoleVos = baseService.findBySql(TmRoleVo.class, sql, positionId);
            if (CollectionUtil.listNotEmptyNotSizeZero(tmRoleVos)) {
                for (TmRoleVo tmRoleVo : tmRoleVos) {
                    if (roleBuffer.length() > 0) {
                        roleBuffer.append(",");
                    }
                    roleBuffer.append(tmRoleVo.getRoleCode());
                }
            }
            return roleBuffer.toString();
        }
        return null;
    }

    public static final String getCreateName() {
        Client client;
        HttpSession session = ContextHolderUtils.getSession();
        Object ob = session.getAttribute(session.getId());
        if (ob != null && (client = (Client)ob) != null) {
            TmUserEntity user = client.getUser();
            TmPositionVo position = client.getPosition();
            if (user == null || position == null) {
                return null;
            }
            return user.getFullName() + "(" + position.getPositionName() + ")";
        }
        return null;
    }

    public static final String getJdbcUrl() {
        return DBTypeUtil.getDBType().toLowerCase();
    }

    public static final String getSysConfigProperty(String propertyName) {
        String value = null;
        ResourceBundle rb = ResourceBundle.getBundle("sysconfig");
        if (rb.containsKey(propertyName)) {
            value = rb.getString(propertyName);
        }
        return value;
    }

    public static Client getClient() {
        HttpSession session = ContextHolderUtils.getSession();
        Object ob = session.getAttribute(session.getId());
        Client client = new Client();
        if (ob != null) {
            client = (Client)ob;
        }
        return client;
    }

    public static void setClient(Client client) {
        HttpSession session = ContextHolderUtils.getSession();
        session.setAttribute(ContextHolderUtils.getSession().getId(), (Object)client);
    }

    public static void addString(String key, String value) {
        HttpSession session = ContextHolderUtils.getSession();
        session.setAttribute(key + session.getId(), (Object)value);
    }

    public static String getString(String key) {
        HttpSession session = ContextHolderUtils.getSession();
        Object ob = session.getAttribute(key + session.getId());
        return ob != null ? ob.toString() : "";
    }
}

