/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.mdm.interceptors;

import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.util.ContextHolderUtils;
import com.biz.eisp.base.common.util.ResourceUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.mdm.function.service.MenuPermissionService;
import com.biz.eisp.mdm.position.service.TmPositionService;
import com.biz.eisp.mdm.role.vo.TmRoleFunctionVo;
import com.biz.eisp.mdm.user.entity.TmUserEntity;
import com.biz.eisp.mdm.web.pojo.Client;
import java.io.IOException;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class AuthInterceptor
implements HandlerInterceptor {
    private List<String> excludeUrls;
    @Autowired
    private MenuPermissionService menuPermissionService;
    @Autowired
    private TmPositionService tmPositionService;

    public List<String> getExcludeUrls() {
        return this.excludeUrls;
    }

    public void setExcludeUrls(List<String> excludeUrls) {
        this.excludeUrls = excludeUrls;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object object, Exception exception) throws Exception {
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object object, ModelAndView modelAndView) throws Exception {
        String accessEntry = request.getParameter("clickFunctionId");
        if (StringUtil.isEmpty(accessEntry)) {
            accessEntry = request.getParameter("accessEntry");
        }
        request.setAttribute("accessEntry", (Object)accessEntry);
        String pub_version = ResourceUtil.getSysConfigProperty("pub_version");
        request.setAttribute("pubVersion", (Object)pub_version);
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object object) throws Exception {
        String reqUrl = ResourceUtil.getRequestPath(request);
        String phoneSend = request.getParameter("phoneSend");
        String posId = request.getParameter("posId");
        String userId = request.getParameter("userId");
        String subFlag = request.getParameter("subFlag");
        HttpSession session = ContextHolderUtils.getSession();
        Client client = ResourceUtil.getClient();
        if (client == null) {
            client = ResourceUtil.getClient();
        }
        if (StringUtil.isNotEmpty((String)phoneSend) && phoneSend.equals("1")) {
            if (StringUtil.isNotEmpty((String)userId) && StringUtil.isNotEmpty((String)posId) && !"offline".equalsIgnoreCase(subFlag) && !Globals.phoneNoIntecepter.containsKey(reqUrl) && this.tmPositionService.isMainPosition(posId) == 0L) {
                this.tmPositionService.updatePositionIsMain(userId, posId);
            }
            return true;
        }
        if (this.excludeUrls.contains(reqUrl)) {
            return true;
        }
        if (client == null) {
            this.forward(request, response);
            return false;
        }
        TmUserEntity tmUserEntity = client.getUser();
        boolean isPermission = this.menuPermissionService.getFunctionsByRequest(request, tmUserEntity);
        if (!isPermission && !Globals.Admin_Name.equalsIgnoreCase(tmUserEntity.getUserName()) && tmUserEntity.getUserType() != Globals.OTHER_USER) {
            this.noPermisson(response);
            return false;
        }
        List<TmRoleFunctionVo> roleFunctionVos = this.menuPermissionService.getOperationsByRequest(request, tmUserEntity);
        this.menuPermissionService.getDataRuleByRequest(request, roleFunctionVos);
        return true;
    }

    public void noPermisson(HttpServletResponse response) throws IOException {
        response.sendRedirect("loginController.do?noPermisson");
    }

    @RequestMapping(params={"forword"})
    public ModelAndView forword(HttpServletRequest request) {
        return new ModelAndView("redirect:/loginController.do?login");
    }

    private void forward(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        request.getRequestDispatcher("pages/login/timeout.jsp").forward((ServletRequest)request, (ServletResponse)response);
    }
}

