select 
t.id as id,
t.contentId as contentId,
t.create_process_position_name as createProcessPositionName,
t.business_key as businessKey,
t.process_instance_id as processInstanceId,
t.process_key as processKey,
t.process_name as processName,
t.view_status as viewStatus,
t.process_title as processTitle,
t.showName as showName,
t.is_reply as isReply,
t.type as type,
t.in_out as inOut,
t.create_name as createName,
t.update_name as updateName,
to_char(t.create_date,'yyyy-MM-dd') as createDate,
to_char(t.update_date,'yyyy-MM-dd') as updateDate
from(
    select 
    t1.id,
    '' as contentId,
    t1.business_key,
    t1.process_instance_id,
    t1.process_name,
    t1.process_key,
    t1.process_title,
    t1.create_date,
    t1.create_name,
    t1.update_date,
    t1.update_name,
    t1.view_status,
    '1' as is_reply,
    t1.create_process_position_name,
    '系统' as showName,
    '0' as type,
    '-1' as in_out
    from 
    ta_copy t1  
    where 1=1
    <#if query.queryCode ?exists && query.queryCode ?length gt 0>
		AND t1.copy_code = '${query.queryCode}'
	</#if>
    <#if query.processInstanceId ?exists && query.processInstanceId ?length gt 0>
		AND t1.process_instance_id = '${query.processInstanceId}'
	</#if>	
    <#if query.businessKey ?exists && query.businessKey ?length gt 0>
		AND t1.business_key = '${query.businessKey}'
	</#if>
	
    union 
    
    select distinct * from (
    select
      t2.id,
      t3.id as contentId,
      t2.business_key,
      t2.process_instance_id,
      t2.process_name,
      t2.process_key,
      t2.process_title,
      t2.create_date,
      t2.create_name,
      t2.update_date,
      t2.update_name,
      t3.view_status,
      t3.is_reply,
      t2.create_process_position_name,
      t2.LAUNCH_NAME as showName,
      '1' as type,
      '0' as in_out
    from 
    ta_circulation t2
    left join ta_circulation_content t3
    on t2.id = t3.ta_circulation_id
    where 1=1
    <#if query.queryCode ?exists && query.queryCode ?length gt 0>
		AND t3.CIRCULATION_CODE = '${query.queryCode}'
	</#if>
    <#if query.processInstanceId ?exists && query.processInstanceId ?length gt 0>
		AND t2.process_instance_id = '${query.processInstanceId}'
	</#if>	
    <#if query.businessKey ?exists && query.businessKey ?length gt 0>
		AND t2.business_key = '${query.businessKey}'
	</#if>
	)
    union
    select distinct * from (
    select
      t4.id,
      t5.id as contentId,
      t4.business_key,
      t4.process_instance_id,
      t4.process_name,
      t4.process_key,
      t4.process_title,
      t4.create_date,
      t4.create_name,
      t4.update_date,
      t4.update_name,
      t5.view_status as view_status,
      '1' as is_reply,
      t4.create_process_position_name,
      t5.CIRCULATION_NAME as showName,
      '1' as type,
      '1' as in_out
    from 
    ta_circulation t4
    left join ta_circulation_content t5
    on t4.id = t5.ta_circulation_id
    where 1=1
    <#if query.queryCode ?exists && query.queryCode ?length gt 0>
		AND t4.LAUNCH_CODE = '${query.queryCode}'
	</#if>
    <#if query.processInstanceId ?exists && query.processInstanceId ?length gt 0>
		AND t4.process_instance_id = '${query.processInstanceId}'
	</#if>	
    <#if query.businessKey ?exists && query.businessKey ?length gt 0>
		AND t4.business_key = '${query.businessKey}'
	</#if>
	)
)t
LEFT JOIN ta_base_business_obj bo ON bo.id = t.business_key
where 1=1

<#if query.processInstanceIdQuery ?exists && query.processInstanceIdQuery ?length gt 0>
AND t.process_instance_id like '%${query.processInstanceIdQuery}%'
</#if>

<#if query.processName ?exists && query.processName ?length gt 0>
AND t.process_name like '%${query.processName}%'
</#if>

<#if query.processTitle ?exists && query.processTitle ?length gt 0>
AND t.process_title like '%${query.processTitle}%'
</#if>


<#if query.createProcessPositionName ?exists && query.createProcessPositionName ?length gt 0>
AND t.create_process_position_name like '%${query.createProcessPositionName}%'
</#if>


<#if query.viewStatus ?exists && query.viewStatus ?length gt 0>
AND t.view_status = '${query.viewStatus}'
</#if>

<#if query.showName ?exists && query.showName ?length gt 0>
AND t.showName LIKE '%${query.showName}%'
</#if>

<#if query.type ?exists && query.type ?length gt 0>
AND t.type = '${query.type}'
</#if>

<#if query.createDate ?exists && query.createDate ?length gt 0>
AND to_char(t.create_date,'yyyy-MM-dd') = '${query.createDate}'
</#if>

order by t.create_date desc