/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.interfacedao.common;

import freemarker.cache.StringTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class FreemarkerParseFactory {
    private static final Logger logger = Logger.getLogger(FreemarkerParseFactory.class);
    private static final String ENCODE = "utf-8";
    private static final Configuration _tplConfig = new Configuration();
    private static final Configuration _sqlConfig = new Configuration();
    private static StringTemplateLoader stringTemplateLoader = new StringTemplateLoader();
    private static final Pattern p = Pattern.compile("(?ms)/\\*.*?\\*/|^\\s*//.*?$");

    public static boolean isExistTemplate(String tplName) {
        try {
            Template mytpl = _tplConfig.getTemplate(tplName, "UTF-8");
            if (mytpl == null) {
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static String parseTemplate(String tplName, Map<String, Object> paras) {
        try {
            StringWriter swriter = new StringWriter();
            Template mytpl = _tplConfig.getTemplate(tplName, ENCODE);
            mytpl.process(paras, (Writer)swriter);
            return FreemarkerParseFactory.getSqlText(swriter.toString());
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), e.fillInStackTrace());
            logger.error((Object)("\u53d1\u9001\u4e00\u6b21\u7684\u6a21\u677fkey:{ " + tplName + " }"));
            System.err.println(e.getMessage());
            System.err.println("\u6a21\u677f\u540d:{ " + tplName + " }");
            throw new RuntimeException("\u89e3\u6790SQL\u6a21\u677f\u5f02\u5e38");
        }
    }

    public static int parseTemplate(String tplName, Map<String, Object> paras, String filePath) {
        try {
            Template mytpl = _tplConfig.getTemplate(tplName, ENCODE);
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(filePath), ENCODE);
            mytpl.process(paras, (Writer)out);
            ((Writer)out).close();
            return 1;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), e.fillInStackTrace());
            logger.error((Object)("\u53d1\u9001\u4e00\u6b21\u7684\u6a21\u677fkey:{ " + tplName + " }"));
            e.printStackTrace();
            throw new RuntimeException("\u89e3\u6790SQL\u6a21\u677f\u5f02\u5e38");
        }
    }

    public static String parseTemplateContent(String tplContent, Map<String, Object> paras) {
        try {
            StringWriter swriter = new StringWriter();
            if (stringTemplateLoader.findTemplateSource("sql_" + tplContent.hashCode()) == null) {
                stringTemplateLoader.putTemplate("sql_" + tplContent.hashCode(), tplContent);
            }
            Template mytpl = _sqlConfig.getTemplate("sql_" + tplContent.hashCode(), ENCODE);
            mytpl.process(paras, (Writer)swriter);
            return FreemarkerParseFactory.getSqlText(swriter.toString());
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), e.fillInStackTrace());
            logger.error((Object)("\u53d1\u9001\u4e00\u6b21\u7684\u6a21\u677fkey:{ " + tplContent + " }"));
            System.err.println(e.getMessage());
            System.err.println("\u6a21\u677f\u5185\u5bb9:{ " + tplContent + " }");
            throw new RuntimeException("\u89e3\u6790SQL\u6a21\u677f\u5f02\u5e38");
        }
    }

    private static String getSqlText(String sql) {
        sql = p.matcher(sql).replaceAll("");
        if ((sql = sql.replaceAll("\\n", " ").replaceAll("\\t", " ").replaceAll("\\s{1,}", " ").trim()).endsWith("where") || sql.endsWith("where ")) {
            sql = sql.substring(0, sql.lastIndexOf("where"));
        }
        int index = 0;
        while ((index = StringUtils.indexOfIgnoreCase((String)sql, (String)"where and", (int)index)) != -1) {
            sql = sql.substring(0, index + 5) + sql.substring(index + 9, sql.length());
        }
        index = 0;
        while ((index = StringUtils.indexOfIgnoreCase((String)sql, (String)", where", (int)index)) != -1) {
            sql = sql.substring(0, index) + sql.substring(index + 1, sql.length());
        }
        if (sql.endsWith(",") || sql.endsWith(", ")) {
            sql = sql.substring(0, sql.lastIndexOf(","));
        }
        return sql;
    }

    static {
        _tplConfig.setClassForTemplateLoading(new FreemarkerParseFactory().getClass(), "/");
        _tplConfig.setNumberFormat("0.#####################");
        _sqlConfig.setTemplateLoader((TemplateLoader)stringTemplateLoader);
        _sqlConfig.setNumberFormat("0.#####################");
    }
}

