SELECT * FROM (
	SELECT
	  distinct
	  'N' AS isCommunicate,
	  to_char(cast(t.id_ as nvarchar2(64))) AS id,
	  pd.id_ AS processDefinitionId,
	  to_char(cast(pd.key_ as nvarchar2(255))) AS processDefinitionKey,
	  to_char(cast(pd.name_ as nvarchar2(255))) AS processDefinitionName,
	  bo.process_title AS processTitle,
	  pi.id_ AS processInstanceId,
	  to_char(bo.create_time, 'yyyy-mm-dd hh24:mi:ss') AS createTime,
	  to_char(cast(t.name_ as nvarchar2(255))) AS taskName,
	  to_char(cast(t.id_ as nvarchar2(64))) AS taskId,
	  bo.runtime_status_id AS runTimeStatusId,
	  to_char(cast(t.task_def_key_ as nvarchar2(255))) AS taskDefinitionKey,
	  to_char(t.create_time_, 'yyyy-mm-dd hh24:mi:ss') AS preNodetime,
	  bo.full_name||'（'||bo.position_name||'）' AS createUserName,
	  o.org_name AS orgName
	FROM
	    act_ru_task t                   
	LEFT JOIN act_ru_identitylink i ON i.task_id_ = t.id_ 
	LEFT JOIN act_re_procdef pd ON pd.id_ = t.proc_def_id_  
	LEFT JOIN act_hi_procinst pi ON pi.proc_inst_id_ = t.proc_inst_id_
	LEFT JOIN ta_base_business_obj bo ON bo.id = pi.business_key_
	LEFT JOIN tm_position p ON p.position_code = bo.position_code
	LEFT JOIN tm_org o ON o.id = p.org_id
	WHERE (
	      t.assignee_ = '${myTaskVo.assignee}' 
	      OR (
	      t.assignee_ IS NULL
	      AND i.user_id_ = '${myTaskVo.assignee}' 
	      )
	)         
	AND t.suspension_state_ = 1
	<#if myTaskVo.processInstanceId ?exists && myTaskVo.processInstanceId ?length gt 0>
		AND pi.id_ LIKE '%${myTaskVo.processInstanceId}%'
	</#if>
	<#if myTaskVo.processDefinitionKey ?exists && myTaskVo.processDefinitionKey ?length gt 0>
		AND pd.key_ LIKE '%${myTaskVo.processDefinitionKey}%'
	</#if>
	<#if myTaskVo.processDefinitionName ?exists && myTaskVo.processDefinitionName ?length gt 0>
		AND pd.name_ LIKE '%${myTaskVo.processDefinitionName}%'
	</#if>
	<#if myTaskVo.processTitle ?exists && myTaskVo.processTitle ?length gt 0>
		AND bo.process_title LIKE '%${myTaskVo.processTitle}%'
	</#if>
	<#if myTaskVo.createTime ?exists && myTaskVo.createTime ?length gt 0>
		AND to_char(bo.create_time,'yyyy-mm-dd') = '${myTaskVo.createTime}'
	</#if>
	<#if myTaskVo.createUserName ?exists && myTaskVo.createUserName ?length gt 0>
		AND (bo.full_name LIKE '%${myTaskVo.createUserName}%' OR bo.position_name LIKE '%${myTaskVo.createUserName}%')
	</#if>
	<#if myTaskVo.orgName ?exists && myTaskVo.orgName ?length gt 0>
		AND o.org_name LIKE '%${myTaskVo.orgName}%'
	</#if>
	<#if myTaskVo.createTimeBegin ?exists && myTaskVo.createTimeBegin ?length gt 0>
		AND to_char(bo.create_time, 'yyyy-mm-dd') >= '${myTaskVo.createTimeBegin}'
	</#if>
  <#if myTaskVo.createTimeEnd ?exists && myTaskVo.createTimeEnd ?length gt 0>
		AND to_char(bo.create_time, 'yyyy-mm-dd') <= '${myTaskVo.createTimeEnd}'
	</#if>

  UNION

  SELECT
  distinct
          'Y' AS isCommunicate,
          cc.id AS id,
          NULL AS processDefinitionId,
          c.process_key AS processDefinitionKey,
          c.process_name AS processDefinitionName,
          bo.process_title AS processTitle,
          pi.id_ AS processInstanceId,
          to_char(bo.create_time,
          'yyyy-mm-dd hh24:mi:ss') AS createTime,
          c.task_name AS taskName,
          c.task_id AS taskId,
          bo.runtime_status_id AS runTimeStatusId,
          c.process_node_key AS taskDefinitionKey,
          ' ' AS preNodetime,
          bo.full_name||'（'||bo.position_name||'）' AS createUserName,
          o.org_name AS orgName
  FROM ta_communicate_content cc
       LEFT JOIN ta_communicate c ON c.id = cc.ta_communicate_id
       LEFT JOIN act_hi_procinst pi ON pi.proc_inst_id_ = c.process_instance_id
       LEFT JOIN ta_base_business_obj bo ON bo.id = pi.business_key_
       LEFT JOIN tm_position p ON p.position_code = bo.position_code
       LEFT JOIN tm_org o ON o.id = p.org_id
  WHERE cc.is_reply = '0' AND cc.circulation_code = '${myTaskVo.assignee}'
  <#if myTaskVo.processInstanceId ?exists && myTaskVo.processInstanceId ?length gt 0>
		AND pi.id_ LIKE '%${myTaskVo.processInstanceId}%'
	</#if>
	<#if myTaskVo.processDefinitionKey ?exists && myTaskVo.processDefinitionKey ?length gt 0>
		AND c.process_key LIKE '%${myTaskVo.processDefinitionKey}%'
	</#if>
	<#if myTaskVo.processDefinitionName ?exists && myTaskVo.processDefinitionName ?length gt 0>
		AND c.process_name LIKE '%${myTaskVo.processDefinitionName}%'
	</#if>
	<#if myTaskVo.processTitle ?exists && myTaskVo.processTitle ?length gt 0>
		AND bo.process_title LIKE '%${myTaskVo.processTitle}%'
	</#if>
	<#if myTaskVo.createTime ?exists && myTaskVo.createTime ?length gt 0>
		AND to_char(bo.create_time,'yyyy-mm-dd') = '${myTaskVo.createTime}'
	</#if>
	<#if myTaskVo.createUserName ?exists && myTaskVo.createUserName ?length gt 0>
		AND (bo.full_name LIKE '%${myTaskVo.createUserName}%' OR bo.position_name LIKE '%${myTaskVo.createUserName}%')
	</#if>
	<#if myTaskVo.orgName ?exists && myTaskVo.orgName ?length gt 0>
		AND o.org_name LIKE '%${myTaskVo.orgName}%'
	</#if>
	<#if myTaskVo.createTimeBegin ?exists && myTaskVo.createTimeBegin ?length gt 0>
		AND to_char(bo.create_time, 'yyyy-mm-dd') >= '${myTaskVo.createTimeBegin}'
	</#if>
  <#if myTaskVo.createTimeEnd ?exists && myTaskVo.createTimeEnd ?length gt 0>
		AND to_char(bo.create_time, 'yyyy-mm-dd') <= '${myTaskVo.createTimeEnd}'
	</#if>
)
ORDER BY preNodetime DESC