/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.activiti.runtime.service.impl;

import com.biz.eisp.activiti.designer.processconf.entity.TaProcessEntity;
import com.biz.eisp.activiti.designer.processconf.service.TaProcessService;
import com.biz.eisp.activiti.runtime.dao.TaCarbonCopyDao;
import com.biz.eisp.activiti.runtime.entity.TaBaseBusinessObjQueryEntity;
import com.biz.eisp.activiti.runtime.entity.TaCarbonCopyEntity;
import com.biz.eisp.activiti.runtime.entity.TaCirculationContentEntity;
import com.biz.eisp.activiti.runtime.entity.TaCirculationEntity;
import com.biz.eisp.activiti.runtime.service.TaCarbonCopyService;
import com.biz.eisp.activiti.runtime.transformer.TaCarbonCopyEntityToTaCarbonCopyVo;
import com.biz.eisp.activiti.runtime.vo.TaCarbonCopyVo;
import com.biz.eisp.activiti.runtime.vo.TaCopyCirculationVo;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.util.ResourceUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;
import com.biz.eisp.mdm.position.entity.TmPositionEntity;
import com.biz.eisp.mdm.position.vo.TmPositionVo;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.List;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.Task;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="taCarbonCopyService")
@Transactional
public class TaCarbonCopyServiceImpl
extends BaseServiceImpl
implements TaCarbonCopyService {
    @Autowired
    private TaCarbonCopyDao taCarbonCopyDao;
    @Autowired
    private TaProcessService taProcessService;
    @Autowired(required=false)
    private RepositoryService repositoryService;
    @Autowired
    private TaskService taskService;
    @Autowired
    private RuntimeService runtimeService;

    @Override
    public List<TaCarbonCopyVo> getAllByProcessKey(String taProcessKey) {
        String hql = "from TaCarbonCopyEntity t where t.taProcessKey = ?";
        List list = this.findByHql(hql, taProcessKey);
        return Lists.transform(list, (Function)new TaCarbonCopyEntityToTaCarbonCopyVo());
    }

    @Override
    public List<TaCopyCirculationVo> getCarbonCopyByConditions(TaCopyCirculationVo vo, Page page) {
        TmPositionVo loginPosition = ResourceUtil.getCurrPosition();
        vo.setQueryCode(loginPosition.getPositionCode());
        String processInstanceId = vo.getProcessInstanceId();
        if (StringUtils.isNotBlank((CharSequence)processInstanceId)) {
            vo.setProcessInstanceIdQuery(processInstanceId);
            vo.setProcessInstanceId(null);
        }
        List<TaCopyCirculationVo> list = this.taCarbonCopyDao.findCarbonCopyAndCirculation(vo, page);
        return list;
    }

    @Override
    public void saveCirculation(String taskId, String codes, String names, String fullNames, String content) {
        boolean flag = this.validateValues(taskId, codes, names, content);
        int wordCount = StringUtil.getWordCount(content);
        if (wordCount > 250) {
            throw new BusinessException("\u5185\u5bb9\u957f\u5ea6\u8d85\u8fc7250\u4e2a\u5b57,\u8bf7\u91cd\u5199");
        }
        if (flag) {
            String[] code = codes.split(",");
            String[] name = names.split(",");
            String[] fullName = fullNames.split(",");
            Task task = (Task)this.taskService.createTaskQuery().taskId(taskId).singleResult();
            ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionId(task.getProcessDefinitionId()).singleResult();
            String piId = task.getProcessInstanceId();
            ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(piId).singleResult();
            String businessKey = processInstance.getBusinessKey();
            TaBaseBusinessObjQueryEntity businessObjEntity = this.get(TaBaseBusinessObjQueryEntity.class, (Serializable)((Object)businessKey));
            TmPositionEntity tmPosition = businessObjEntity.getTmPositionEntity();
            TaCirculationEntity circulation = new TaCirculationEntity();
            circulation.setBusinessKey(businessKey);
            circulation.setProcessInstanceId(piId);
            circulation.setProcessName(processDefinition.getName());
            circulation.setProcessKey(processDefinition.getKey());
            circulation.setProcessTitle(businessObjEntity.getProcessTitle());
            circulation.setLaunchCode(ResourceUtil.getCurrPosition().getPositionCode());
            circulation.setLaunchName(ResourceUtil.getCreateName());
            circulation.setCreateProcessPositionCode(tmPosition.getPositionCode());
            circulation.setCreateProcessPositionName(tmPosition.getPositionName());
            super.save(circulation);
            for (int i = 0; i < code.length; ++i) {
                TaCirculationContentEntity cirContent = new TaCirculationContentEntity();
                cirContent.setTaCirculationId(circulation.getId());
                cirContent.setContent(content);
                cirContent.setCirculationCode(code[i]);
                cirContent.setCirculationName(fullName[i] + "(" + name[i] + ")");
                cirContent.setViewStatus("0");
                cirContent.setReadStatus("0");
                cirContent.setIsReply("0");
                this.save(cirContent);
            }
        }
    }

    @Override
    public void delCarbonCopyById(String ids) {
        if (StringUtils.isNotBlank((CharSequence)ids)) {
            String[] strs = ids.split(",");
            for (int i = 0; i < strs.length; ++i) {
                TaCarbonCopyEntity entity = this.get(TaCarbonCopyEntity.class, (Serializable)((Object)strs[i]));
                this.delete(entity);
            }
        }
    }

    @Override
    public AjaxJson saveCarbonCopy(TaCarbonCopyVo vo) {
        AjaxJson aj = new AjaxJson();
        String taProcessId = vo.getTaProcessId();
        String code = vo.getCode();
        String name = vo.getName();
        String state = vo.getState();
        String chooseCondition = vo.getChooseCondition();
        if (StringUtils.isNotEmpty((CharSequence)taProcessId) && StringUtils.isNotEmpty((CharSequence)state)) {
            String[] codes = code.split(",");
            String[] names = name.split(",");
            for (int i = 0; i < codes.length; ++i) {
                String c = codes[i];
                String n = names[i];
                boolean flag = this.validateData(c, taProcessId);
                if (!flag) {
                    aj.setMsg("\u5df2\u7ecf\u6709\u91cd\u590d\u7684\u6570\u636e\uff0c\u4e0d\u80fd\u518d\u6dfb\u52a0");
                    aj.setSuccess(flag);
                    return aj;
                }
                TaProcessEntity processEntity = this.taProcessService.get(TaProcessEntity.class, (Serializable)((Object)taProcessId));
                TaCarbonCopyEntity copyEntity = new TaCarbonCopyEntity();
                copyEntity.setTaProcessId(taProcessId);
                copyEntity.setTaProcessKey(processEntity.getProcessKey());
                copyEntity.setCode(c);
                copyEntity.setName(n);
                copyEntity.setState(state);
                if (state.equals("0")) {
                    copyEntity.setChooseCondition(chooseCondition);
                } else if (state.equals("1")) {
                    copyEntity.setChooseCondition("0");
                }
                this.save(copyEntity);
            }
        }
        return aj;
    }

    @Override
    public List<TaCopyCirculationVo> findCopyAndCirculation(TaCopyCirculationVo vo, Page page) {
        TmPositionVo loginPosition = ResourceUtil.getCurrPosition();
        if (StringUtils.isBlank((CharSequence)loginPosition.getPositionCode())) {
            String sql = "select * from ta_copy t where t.id = '-1'";
            return this.findBySql(TaCopyCirculationVo.class, sql, page, new Object[0]);
        }
        vo.setQueryCode(loginPosition.getPositionCode());
        List<TaCopyCirculationVo> result = this.taCarbonCopyDao.findCarbonCopyAndCirculationList(vo, page);
        return result;
    }

    @Override
    public List<TaCarbonCopyVo> findTaCarbonCopy(TaCarbonCopyVo vo, Page page) {
        SimpleExpression cr1 = null;
        SimpleExpression cr2 = null;
        SimpleExpression cr3 = null;
        if (StringUtils.isNotEmpty((CharSequence)vo.getTaProcessId())) {
            SimpleExpression cr4 = Restrictions.eq((String)"taProcessId", (Object)vo.getTaProcessId());
            if (null != vo.getCode() && !"".equals(vo.getCode())) {
                cr1 = Restrictions.like((String)"code", (Object)("%" + vo.getCode() + "%"));
            }
            if (null != vo.getName() && !"".equals(vo.getName())) {
                cr2 = Restrictions.like((String)"name", (Object)("%" + vo.getName() + "%"));
            }
            if (null != vo.getState() && !"".equals(vo.getState())) {
                cr3 = Restrictions.eq((String)"state", (Object)vo.getState());
            }
            List<TaCarbonCopyEntity> result = this.findByCriteria(TaCarbonCopyEntity.class, new Criterion[]{cr1, cr2, cr3, cr4});
            return Lists.transform(result, (Function)new TaCarbonCopyEntityToTaCarbonCopyVo());
        }
        throw new BusinessException("\u5bf9\u4e0d\u8d77\uff0c\u6570\u636e\u5f02\u5e38\uff0c\u8054\u7cfb\u7ba1\u7406\u5458");
    }

    private boolean validateData(String code, String taProcessId) {
        String sql = "select * from ta_carboncopy t where t.ta_process_id = ? and t.code = ?";
        List<TaCarbonCopyEntity> list = this.findBySql(TaCarbonCopyEntity.class, sql, taProcessId, code);
        return list.size() == 0;
    }

    private boolean validateValues(String ... strs) {
        for (int i = 0; i < strs.length; ++i) {
            if (StringUtils.isNotBlank((CharSequence)strs[i])) continue;
            return false;
        }
        return true;
    }

    private int getWordCountRegex(String s) {
        s = s.replaceAll("[^\\x00-\\xff]", "**");
        int length = s.length();
        return length;
    }
}

