/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.mdm.dict.service.impl;

import com.biz.eisp.api.TmMqSerivce;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;
import com.biz.eisp.mdm.dict.entity.TmDictDataEntity;
import com.biz.eisp.mdm.dict.entity.TmDictTypeEntity;
import com.biz.eisp.mdm.dict.service.TmDictDataService;
import com.biz.eisp.mdm.dict.service.TmDictTypeService;
import com.biz.eisp.mdm.dict.util.DictUtil;
import com.biz.eisp.mdm.dict.vo.DictTreeGrid;
import com.biz.eisp.mdm.dict.vo.TmDictDataVo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="tmDictDataService")
@Transactional
public class TmDictDataServiceImpl
extends BaseServiceImpl
implements TmDictDataService {
    @Autowired
    private TmDictTypeService tmDictTypeService;
    @Autowired(required=false)
    private TmMqSerivce tmMqSerivce;

    @Override
    public void saveAndUpdate(DictTreeGrid dictTreegrid) {
        TmDictDataEntity dictData = null;
        String id = dictTreegrid.getId();
        String parentId = dictTreegrid.getParentId();
        String dictTypeCode = dictTreegrid.getDictTypeCode();
        TmDictTypeEntity dictTypeEntity = this.getDictTypeEntity(dictTypeCode);
        if (id == null || "".equals(id)) {
            dictData = dictTreegrid.getDictData(dictTypeEntity, this.get(parentId));
            dictData.setId(null);
            this.saveOrUpdate(dictData);
        } else {
            TmDictDataEntity tdd = this.get(TmDictDataEntity.class, (Serializable)((Object)id.split("_")[0]));
            if (tdd == null) {
                throw new BusinessException("\u60a8\u6240\u8981\u4fee\u6539\u7684\u6570\u636e\u5b57\u5178\u503c\u4e0d\u5b58\u5728");
            }
            dictData = dictTreegrid.getDictData(dictTypeEntity, this.get(parentId));
            tdd.setId(dictData.getId());
            tdd.setDictCode(dictData.getDictCode());
            tdd.setTmDictType(dictData.getTmDictType());
            tdd.setTmDictData(dictData.getTmDictData());
            tdd.setDictDesc(dictData.getDictDesc());
            tdd.setDictValue(dictData.getDictValue());
            this.saveOrUpdate(tdd);
        }
        if (StringUtil.isNotEmpty(this.tmMqSerivce)) {
            this.tmMqSerivce.dicCallBack(dictData);
        } else {
            this.syncDictCache();
        }
    }

    @Override
    public void syncDictCache() {
        List<TmDictTypeEntity> typeGroups = this.loadAll(TmDictTypeEntity.class);
        for (TmDictTypeEntity dictTypeEntity : typeGroups) {
            DictUtil.allDictType.put(dictTypeEntity.getDictTypeCode(), dictTypeEntity);
            List<TmDictDataEntity> list = this.findByProperty(TmDictDataEntity.class, "tmDictType.dictTypeCode", dictTypeEntity.getDictTypeCode());
            if (!CollectionUtil.listNotEmptyNotSizeZero(list)) continue;
            DictUtil.allDictData.put(dictTypeEntity.getDictTypeCode(), list);
        }
    }

    private TmDictTypeEntity getDictTypeEntity(String dictTypeCode) {
        SimpleExpression cr1 = Restrictions.eq((String)"dictTypeCode", (Object)dictTypeCode);
        List<TmDictTypeEntity> dictType = this.findByCriteria(TmDictTypeEntity.class, new Criterion[]{cr1});
        if (CollectionUtils.isEmpty(dictType)) {
            throw new BusinessException("\u6570\u636e\u5b57\u5178\u7c7b\u578b\u4e0d\u5b58\u5728");
        }
        return dictType.get(0);
    }

    @Override
    public void deleteDictData(String id) {
        TmDictDataEntity t = super.get(TmDictDataEntity.class, (Serializable)((Object)id));
        List<TmDictDataEntity> tdds = super.findByProperty(TmDictDataEntity.class, "tmDictData", t);
        if (tdds != null && tdds.size() > 0) {
            throw new BusinessException("\u5220\u9664\u7684\u5bf9\u8c61\u6709\u5b50\u5bf9\u8c61\uff0c\u4e0d\u80fd\u5220\u9664");
        }
        super.delete(t);
        if (StringUtil.isNotEmpty(this.tmMqSerivce)) {
            this.tmMqSerivce.dicCallBack(t);
        } else {
            this.syncDictCache();
        }
    }

    @Override
    public TmDictDataEntity get(String id) {
        return super.get(TmDictDataEntity.class, (Serializable)((Object)id));
    }

    @Override
    public List<TmDictDataEntity> list() {
        return super.loadAll(TmDictDataEntity.class);
    }

    @Override
    public List<TmDictDataEntity> findByType(String typeCode) {
        String hql = "select data from TmDictDataEntity data where data.tmDictType.dictTypeCode = ?";
        return this.findByHql(hql, typeCode);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<DictTreeGrid> getDictsList(HttpServletRequest request, DictTreeGrid dictTreeGrid) {
        String girdID = request.getParameter("id");
        ArrayList<DictTreeGrid> dictTreeGrids = new ArrayList<DictTreeGrid>();
        if (StringUtil.isNotEmpty((String)girdID)) {
            void var7_12;
            String gridId = girdID.split("_")[0];
            String gridType = girdID.split("_")[1];
            ArrayList arrayList = new ArrayList();
            if (gridType.equals("1")) {
                TmDictTypeEntity ty = this.tmDictTypeService.get(gridId);
                List list = this.findByHql("select t from TmDictDataEntity t where t.tmDictData is null and t.tmDictType = ?  order by create_date desc", ty);
            } else {
                TmDictDataEntity td = this.get(gridId);
                List list = this.findByHql("select t from TmDictDataEntity t where t.tmDictData = ?  order by create_date desc", td);
            }
            for (TmDictDataEntity tmDictDataEntity : var7_12) {
                DictTreeGrid d = new DictTreeGrid(tmDictDataEntity);
                dictTreeGrids.add(d);
            }
            return dictTreeGrids;
        }
        List<Object> dictTypeList = new ArrayList();
        dictTypeList = this.findBySql(TmDictTypeEntity.class, "select * from tm_dict_type order by create_date desc", new Object[0]);
        for (TmDictTypeEntity tmDictTypeEntity : dictTypeList) {
            DictTreeGrid d = new DictTreeGrid(tmDictTypeEntity);
            if (this.hasDictData(tmDictTypeEntity)) {
                d.setState("closed");
            }
            dictTreeGrids.add(d);
        }
        return dictTreeGrids;
    }

    private boolean hasDictData(TmDictTypeEntity ty) {
        SimpleExpression cr1 = Restrictions.eq((String)"tmDictType", (Object)ty);
        List<TmDictDataEntity> dicts = this.findByCriteria(TmDictDataEntity.class, new Criterion[]{cr1});
        return !CollectionUtils.isEmpty(dicts) && dicts.size() > 0;
    }

    @Override
    public TmDictDataEntity findByCode(String dictCode, String dictTypeCode) {
        SimpleExpression cr1 = Restrictions.eq((String)"dictCode", (Object)dictCode);
        SimpleExpression cr2 = Restrictions.eq((String)"tmDictType.dictTypeCode", (Object)dictTypeCode);
        List<TmDictDataEntity> dicts = this.findByCriteria(TmDictDataEntity.class, new Criterion[]{cr1, cr2});
        if (!CollectionUtils.isEmpty(dicts)) {
            TmDictDataEntity dictDataEntity = dicts.get(0);
            return dictDataEntity;
        }
        return new TmDictDataEntity();
    }

    @Override
    public List<TmDictDataVo> findVoByType(String typeCode) {
        String sql = "SELECT id AS id, dict_code AS dictCode,dict_value AS dictValue,dict_desc AS dictDesc FROM tm_dict_data WHERE dict_type_code = ?";
        List<TmDictDataVo> dictDataVos = this.findBySql(TmDictDataVo.class, sql, typeCode);
        return dictDataVos;
    }
}

