/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.mdm.user.transformer;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.util.Md5EncryptionAndDecryption;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.utils.PinyinUtil;
import com.biz.eisp.mdm.customer.entity.TmCustomerEntity;
import com.biz.eisp.mdm.custuser.entity.TmRUserCustomerEntity;
import com.biz.eisp.mdm.position.entity.TmPositionEntity;
import com.biz.eisp.mdm.role.entity.TmRoleEntity;
import com.biz.eisp.mdm.user.entity.TmUserEntity;
import com.biz.eisp.mdm.user.entity.TmUserPositionEntity;
import com.biz.eisp.mdm.user.entity.TmUserRoleEntity;
import com.biz.eisp.mdm.user.service.TmUserService;
import com.biz.eisp.mdm.user.vo.TmUserVo;
import com.google.common.base.Function;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class TmUserVoToTmUserEntity
implements Function<TmUserVo, TmUserEntity>,
Serializable {
    private static final long serialVersionUID = 1L;
    private TmUserService tmUserService;

    public TmUserVoToTmUserEntity(TmUserService tmUserService) {
        this.tmUserService = tmUserService;
    }

    public TmUserEntity apply(TmUserVo vo) {
        TmUserEntity entity = new TmUserEntity();
        if (StringUtil.isNotEmpty((String)vo.getId())) {
            entity = this.tmUserService.get(TmUserEntity.class, (Serializable)((Object)vo.getId()));
        } else {
            String hql = " from TmUserEntity where userType=0 and userName=?";
            List list = this.tmUserService.findByHql(hql, vo.getUserName());
            if (list != null && list.size() > 0) {
                throw new BusinessException("\u767b\u5f55\u8d26\u53f7" + vo.getUserName() + "\u5df2\u5b58\u5728");
            }
        }
        try {
            if (!StringUtil.isNotEmpty(vo.getEnableStatus())) {
                vo.setEnableStatus(Globals.ZERO);
            }
            vo.setHeadString(PinyinUtil.getPinYinHeadChar(vo.getFullName()));
            if (!"******".equals(vo.getPassword())) {
                String md5Password = Md5EncryptionAndDecryption.encryPwd(vo.getPassword());
                vo.setPassword(md5Password);
            } else {
                vo.setPassword(null);
            }
            this.copyProperties(vo, entity);
            String positionJson = vo.getPositionJson();
            List<TmUserPositionEntity> userPositionList = this.getTmUserPositionList(vo, entity, positionJson);
            entity.setTmUserPositionList(userPositionList);
            String custId = vo.getCustId();
            List<TmRUserCustomerEntity> tmRUserCustomerList = this.getTmRUserCustomerList(entity, custId);
            entity.setTmRUserCustomerList(tmRUserCustomerList);
            String roleIds = vo.getRoleIds();
            List<TmUserRoleEntity> tmUserRoleList = this.getTmUserRoleList(entity, roleIds);
            entity.setTmUserRoleList(tmUserRoleList);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("\u7528\u6237vo\u8f6c\u6362entity\u5f02\u5e38");
        }
        return entity;
    }

    public void copyProperties(TmUserVo vo, TmUserEntity entity) {
        entity.setEmail(vo.getEmail());
        entity.setBeginDate(vo.getBeginDate());
        entity.setEndDate(vo.getEndDate());
        entity.setEnableStatus(vo.getEnableStatus().shortValue());
        entity.setExtChar1(vo.getExtChar1());
        entity.setExtChar2(vo.getExtChar2());
        entity.setExtChar3(vo.getExtChar3());
        entity.setExtChar4(vo.getExtChar4());
        entity.setExtChar5(vo.getExtChar5());
        entity.setExtChar6(vo.getExtChar6());
        entity.setExtChar7(vo.getExtChar7());
        entity.setExtChar8(vo.getExtChar8());
        entity.setExtChar9(vo.getExtChar9());
        entity.setExtChar10(vo.getExtChar10());
        entity.setExtDate1(vo.getExtDate1());
        entity.setExtDate2(vo.getExtDate2());
        entity.setExtNumber1(vo.getExtNumber1());
        entity.setExtNumber2(vo.getExtNumber2());
        entity.setExtNumber3(vo.getExtNumber3());
        entity.setFullName(vo.getFullName());
        entity.setMobilePhone(vo.getMobilePhone());
        if (StringUtil.isNotEmpty((String)vo.getPassword())) {
            entity.setPassword(vo.getPassword());
        }
        if (StringUtils.isNotBlank((CharSequence)vo.getSex())) {
            entity.setSex(Integer.parseInt(vo.getSex()));
        }
        entity.setUserName(vo.getUserName());
        entity.setHeadString(vo.getHeadString());
        entity.setUserType(vo.getUserType());
    }

    public List<TmUserPositionEntity> getTmUserPositionList(TmUserVo vo, TmUserEntity userEntity, String positionJson) {
        JSONArray array = JSONArray.parseArray((String)positionJson);
        ArrayList<TmUserPositionEntity> tmUserPositionList = new ArrayList<TmUserPositionEntity>();
        if (StringUtil.isNotEmpty(array) && array.size() > 0) {
            for (int i = 0; i < array.size(); ++i) {
                JSONObject obj = array.getJSONObject(i);
                String tmRPositionUserId = obj.getString("tmRPositionUserId");
                String positionId = obj.getString("id");
                String isMain = obj.getString("isMain");
                TmUserPositionEntity userPositionEntity = null;
                if (StringUtils.isNotBlank((CharSequence)tmRPositionUserId)) {
                    userPositionEntity = this.tmUserService.get(TmUserPositionEntity.class, (Serializable)((Object)tmRPositionUserId));
                } else {
                    userPositionEntity = new TmUserPositionEntity();
                    TmPositionEntity positionEntity = this.tmUserService.get(TmPositionEntity.class, (Serializable)((Object)positionId));
                    userPositionEntity.setTmPosition(positionEntity);
                    userPositionEntity.setTmUser(userEntity);
                }
                Calendar startCalendar = Calendar.getInstance();
                startCalendar.setTime(new Date());
                startCalendar.add(5, -1);
                Calendar endCalendar = Calendar.getInstance();
                endCalendar.set(9998, 12, 1, 1, 1, 1);
                userPositionEntity.setIsMain(isMain);
                userPositionEntity.setStartDate(startCalendar.getTime());
                userPositionEntity.setEndDate(endCalendar.getTime());
                userPositionEntity.setStatus(Globals.ZERO);
                tmUserPositionList.add(userPositionEntity);
            }
        }
        return tmUserPositionList;
    }

    public List<TmRUserCustomerEntity> getTmRUserCustomerList(TmUserEntity tmUserEntity, String custId) {
        ArrayList<TmRUserCustomerEntity> list = new ArrayList<TmRUserCustomerEntity>();
        if (StringUtil.isNotEmpty((String)custId)) {
            String hql = "from TmRUserCustomerEntity where tmUser.id=? and tmCustomer.id=?";
            TmRUserCustomerEntity tmRUserCustomerEntity = this.tmUserService.getUniqueByHql(TmRUserCustomerEntity.class, hql, tmUserEntity.getId(), custId);
            if (tmRUserCustomerEntity == null) {
                tmRUserCustomerEntity = new TmRUserCustomerEntity();
                tmRUserCustomerEntity.setTmUser(tmUserEntity);
                tmRUserCustomerEntity.setTmCustomer(this.tmUserService.get(TmCustomerEntity.class, (Serializable)((Object)custId)));
                tmRUserCustomerEntity.setStatus(Globals.ZERO);
                Calendar startCalendar = Calendar.getInstance();
                startCalendar.setTime(new Date());
                startCalendar.add(5, -1);
                Calendar endCalendar = Calendar.getInstance();
                endCalendar.set(9998, 12, 1, 1, 1, 1);
                tmRUserCustomerEntity.setStartDate(startCalendar.getTime());
                tmRUserCustomerEntity.setEndDate(endCalendar.getTime());
            }
            list.add(tmRUserCustomerEntity);
        }
        return list;
    }

    public List<TmUserRoleEntity> getTmUserRoleList(TmUserEntity tmUserEntity, String roleIds) {
        ArrayList<TmUserRoleEntity> list = new ArrayList<TmUserRoleEntity>();
        if (StringUtil.isNotEmpty((String)roleIds)) {
            String hql = "from TmUserRoleEntity where tmUser.id=? and tmRole.id=?";
            for (String roleId : roleIds.split(",")) {
                TmUserRoleEntity tmUserRoleEntity = this.tmUserService.getUniqueByHql(TmUserRoleEntity.class, hql, tmUserEntity.getId(), roleId);
                if (tmUserRoleEntity == null) {
                    tmUserRoleEntity = new TmUserRoleEntity();
                    tmUserRoleEntity.setTmUser(tmUserEntity);
                    tmUserRoleEntity.setTmRole(this.tmUserService.get(TmRoleEntity.class, (Serializable)((Object)roleId)));
                }
                list.add(tmUserRoleEntity);
            }
        }
        return list;
    }
}

