/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.activiti.listener.task;

import com.biz.eisp.activiti.runtime.entity.TaBaseBusinessObjQueryEntity;
import com.biz.eisp.activiti.runtime.entity.TaCopyEntity;
import com.biz.eisp.activiti.runtime.service.TaCarbonCopyService;
import com.biz.eisp.activiti.runtime.vo.TaCarbonCopyVo;
import com.biz.eisp.base.utils.ApplicationContextUtils;
import com.biz.eisp.mdm.actrole.service.TmActRoleService;
import com.biz.eisp.mdm.position.entity.TmPositionEntity;
import com.biz.eisp.mdm.position.vo.TmPositionVo;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import org.activiti.engine.HistoryService;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.ExecutionListener;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.repository.ProcessDefinition;
import org.apache.commons.lang.StringUtils;

public class CarbonCopyListener
implements ExecutionListener {
    private static final long serialVersionUID = 1230733149844003676L;
    private TaCarbonCopyService taCarbonCopyService = (TaCarbonCopyService)ApplicationContextUtils.getContext().getBean("taCarbonCopyService");
    private RepositoryService repositoryService = (RepositoryService)ApplicationContextUtils.getContext().getBean("repositoryService");
    private HistoryService historyService = (HistoryService)ApplicationContextUtils.getContext().getBean("historyService");
    private TmActRoleService tmActRoleService = (TmActRoleService)ApplicationContextUtils.getContext().getBean("tmActRoleService");

    public void notify(DelegateExecution execution) throws Exception {
        String formType = (String)execution.getVariable("FROM_TYPE");
        if (StringUtils.isNotBlank((String)formType) && "PROCESS_PASS_CHECK".equals(formType)) {
            return;
        }
        Object isAbort = execution.getVariable("aborts");
        if (isAbort == null) {
            this.carbonCopy(execution);
        }
    }

    private void carbonCopy(DelegateExecution execution) {
        String piId = execution.getProcessInstanceId();
        String pdId = execution.getProcessDefinitionId();
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionId(pdId).singleResult();
        HistoricProcessInstance hpi = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(piId).singleResult();
        String businessKey = hpi.getBusinessKey();
        TaBaseBusinessObjQueryEntity businessObjEntity = this.taCarbonCopyService.get(TaBaseBusinessObjQueryEntity.class, (Serializable)((Object)businessKey));
        TmPositionEntity tmPositionEntity = businessObjEntity.getTmPositionEntity();
        String processKey = processDefinition.getKey();
        String processName = processDefinition.getName();
        List<TaCarbonCopyVo> ccs = this.taCarbonCopyService.getAllByProcessKey(processKey);
        HashSet<String> innertPosition = new HashSet<String>();
        for (TaCarbonCopyVo vo : ccs) {
            String chooseCondition = vo.getChooseCondition();
            String state = vo.getState();
            String code = vo.getCode();
            if (state.equals("0")) {
                List<TmPositionVo> positions;
                if (chooseCondition.equals("1")) {
                    positions = this.tmActRoleService.findCurrOrgPositionList(code, tmPositionEntity.getTmOrg().getId());
                    for (TmPositionVo tm : positions) {
                        innertPosition.add(tm.getPositionCode());
                    }
                    continue;
                }
                if (chooseCondition.equals("2")) {
                    positions = this.tmActRoleService.findCurrAndBelowOrgPositionList(code, tmPositionEntity.getTmOrg().getId());
                    for (TmPositionVo tm : positions) {
                        innertPosition.add(tm.getPositionCode());
                    }
                    continue;
                }
                if (!chooseCondition.equals("3")) continue;
                positions = this.tmActRoleService.findPositionList(code);
                for (TmPositionVo tm : positions) {
                    innertPosition.add(tm.getPositionCode());
                }
                continue;
            }
            if (!state.equals("1")) continue;
            innertPosition.add(code);
        }
        for (String str : innertPosition) {
            TaCopyEntity copy = new TaCopyEntity();
            copy.setBusinessKey(businessKey);
            copy.setProcessInstanceId(piId);
            copy.setProcessName(processName);
            copy.setProcessKey(processKey);
            copy.setProcessTitle(businessObjEntity.getProcessTitle());
            copy.setCopyCode(str);
            copy.setCopyName("\u7cfb\u7edf");
            copy.setViewStatus("0");
            copy.setCreateProcessPositionCode(tmPositionEntity.getPositionCode());
            copy.setCreateProcessPositionName(tmPositionEntity.getPositionName());
            this.taCarbonCopyService.save(copy);
        }
    }
}

