WITH rd AS (
  SELECT
    t.id_,
    t.assignee_,
    t.proc_inst_id_,
    t.task_def_key_
  FROM act_ru_task t
  WHERE t.assignee_ IS NOT NULL

  UNION ALL

  SELECT
    t.id_,
    i.user_id_ AS assignee_,
    t.proc_inst_id_,
    t.task_def_key_
  FROM act_ru_task t
    LEFT JOIN act_ru_identitylink i ON i.task_id_ = t.id_
  WHERE
    t.assignee_ IS NULL AND i.user_id_ IS NOT NULL
)
SELECT
  t.id_ AS id,
  t.task_def_key_ AS taskDefKey,
  LISTAGG(p.position_name,',') WITHIN GROUP(ORDER BY t.id_) AS roleName,
  LISTAGG(u.username,',') WITHIN GROUP(ORDER BY t.id_) AS account,
  LISTAGG(u.fullname,',') WITHIN GROUP(ORDER BY t.id_) AS name
FROM rd t
  LEFT JOIN tm_position p ON p.position_code = t.assignee_
  LEFT JOIN tm_r_user_position up ON up.position_id = p.id
  LEFT JOIN tm_user u ON u.id = up.user_id
WHERE t.proc_inst_id_ = :processInstanceId
  GROUP BY t.id_,t.task_def_key_


