/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.activiti.runtime.service.impl;

import com.biz.eisp.activiti.entity.activiti.ActHiActinstEntity;
import com.biz.eisp.activiti.runtime.cmd.JumpTaskCmd;
import com.biz.eisp.activiti.runtime.service.TaTaskService;
import com.biz.eisp.activiti.runtime.service.TaskFlowControlService;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.impl.RepositoryServiceImpl;
import org.activiti.engine.impl.RuntimeServiceImpl;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandExecutor;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="taskFlowControlService")
@Transactional
public class TaskFlowControlServiceImpl
extends BaseServiceImpl
implements TaskFlowControlService {
    private static final Logger logger = Logger.getLogger(TaskFlowControlServiceImpl.class);
    private static final String REASION_JUMP = "jump";
    private static final String EVENTNAME_CREATE = "create";
    private static final String EVENTNAME_ASSIGNMENT = "assignment";
    private static final String EVENTNAME_COMPLETE = "complete";
    private static final String EVENTNAME_DELETE = "delete";
    @Autowired
    private TaskService taskService;
    @Autowired
    private RuntimeService runtimeService;
    @Autowired
    RepositoryServiceImpl repositoryService;
    @Autowired
    private TaTaskService taTaskService;

    @Override
    public void jump(String taskId, String targetTaskDefinitionKey, Map<String, Object> variables) throws Exception {
        try {
            TaskEntity currentTaskEntity = (TaskEntity)this.taskService.createTaskQuery().taskId(taskId).singleResult();
            ActivityImpl activity = this.getActivity(currentTaskEntity.getProcessDefinitionId(), targetTaskDefinitionKey);
            CommandExecutor commandExecutor = ((RuntimeServiceImpl)this.runtimeService).getCommandExecutor();
            commandExecutor.execute((Command)new JumpTaskCmd(currentTaskEntity, activity, variables));
            this.doAfterJump(taskId);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public ActivityImpl getActivity(String processDefId, String taskDefKey) {
        ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)this.repositoryService.getDeployedProcessDefinition(processDefId);
        List activitiList = processDefinition.getActivities();
        for (ActivityImpl activityImpl : activitiList) {
            if (!activityImpl.getId().equals(taskDefKey)) continue;
            return activityImpl;
        }
        return null;
    }

    private void doAfterJump(String taskId) {
        ActHiActinstEntity actHiActinstEntity = this.findUniqueByProperty(ActHiActinstEntity.class, "taskId", taskId);
        if (actHiActinstEntity != null) {
            Timestamp nowTime = new Timestamp(new Date().getTime());
            actHiActinstEntity.setEndTime(nowTime);
            actHiActinstEntity.setDuration(nowTime.getTime() - actHiActinstEntity.getStartTime().getTime());
            this.taTaskService.updateEntity(actHiActinstEntity);
        }
    }
}

