/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.mdm.authobj.service.impl;

import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;
import com.biz.eisp.mdm.authobj.entity.TmFunAuthEntity;
import com.biz.eisp.mdm.authobj.entity.TmRoleFuncAuthobjEntity;
import com.biz.eisp.mdm.authobj.service.TmFunAuthService;
import com.biz.eisp.mdm.authobj.vo.TmFunctionAuthVo;
import com.biz.eisp.mdm.dict.entity.TmDictDataEntity;
import com.biz.eisp.mdm.dict.transformer.TmDictDataEntityToTmDictDataVo;
import com.biz.eisp.mdm.dict.vo.TmDictDataVo;
import com.biz.eisp.mdm.role.entity.TmRoleFunctionEntity;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="tmFunAuthService")
@Transactional
public class TmFunAuthServiceImpl
extends BaseServiceImpl
implements TmFunAuthService {
    @Override
    public List<TmFunAuthEntity> getTmFunAuthList(String functionId) {
        return this.findByProperty(TmFunAuthEntity.class, "tmFunction.id", functionId);
    }

    @Override
    public List<TmDictDataEntity> getTmDictData(String dictTypeValue, String authObj) {
        String hql = "from TmDictDataEntity where tmDictType.dictTypeCode=? and dictCode=?";
        List dictDataList = this.findByHql(hql, dictTypeValue, authObj);
        if (dictDataList != null && dictDataList.size() > 0) {
            TmDictDataEntity dictData = (TmDictDataEntity)dictDataList.get(0);
            return this.findByProperty(TmDictDataEntity.class, "tmDictData.id", dictData.getId());
        }
        return null;
    }

    @Override
    public void saveFunAuth(TmFunctionAuthVo funAuth) {
        String functionId = funAuth.getTmFunction().getId();
        String authobj = funAuth.getAuthobj();
        List<TmFunAuthEntity> authList = this.findByProperty(TmFunAuthEntity.class, "tmFunction.id", functionId);
        this.deleteAllEntity(authList);
        if (StringUtil.isNotEmpty((String)authobj)) {
            String[] authObjs = authobj.split(",");
            StringBuffer bufs = new StringBuffer();
            for (String auth : authObjs) {
                if (bufs.length() > 0) {
                    bufs.append(",");
                }
                bufs.append("'").append(auth).append("'");
                String hql = "from TmFunAuthEntity where tmFunction.id=? and authobj=?";
                TmFunAuthEntity tmFunAuth = this.getUniqueByHql(TmFunAuthEntity.class, hql, functionId, auth);
                if (tmFunAuth != null && !StringUtil.isEmpty(tmFunAuth.getId())) continue;
                tmFunAuth = new TmFunAuthEntity();
                tmFunAuth.setAuthobj(auth);
                tmFunAuth.setTmFunction(funAuth.getTmFunction());
                this.save(tmFunAuth);
            }
            String sql = "DELETE FROM TM_R_ROLE_FUNC_AUTHOBJ WHERE ROLE_FUNCTION_ID IN (SELECT TF.ID FROM TM_R_ROLE_FUNCTION TF WHERE TF.FUNCTION_ID=?) AND AUTHOBJ NOT IN(?)";
            this.executeSql(sql, functionId, bufs.toString());
        }
    }

    @Override
    public List<TmFunAuthEntity> getTmFunAuthListByRoleFunc(String roleId, String funcId) {
        TmRoleFunctionEntity tmRoleFunctionEntity;
        List<TmRoleFuncAuthobjEntity> Authobjs;
        SimpleExpression funcCrt;
        HashSet<String> authObjCodes = new HashSet<String>();
        ArrayList<TmFunAuthEntity> funAuths = new ArrayList<TmFunAuthEntity>();
        SimpleExpression roleCrt = Restrictions.eq((String)"tmRole.id", (Object)roleId);
        List<TmRoleFunctionEntity> roleFuncs = this.findByCriteria(TmRoleFunctionEntity.class, new Criterion[]{roleCrt, funcCrt = Restrictions.eq((String)"tmFunction.id", (Object)funcId)});
        if (StringUtil.isNotEmpty(roleFuncs) && roleFuncs.size() > 0 && StringUtil.isNotEmpty(Authobjs = this.findByProperty(TmRoleFuncAuthobjEntity.class, "tmRoleFunction.id", (tmRoleFunctionEntity = roleFuncs.get(0)).getId())) && Authobjs.size() > 0) {
            for (TmRoleFuncAuthobjEntity authObj : Authobjs) {
                authObjCodes.add(authObj.getAuthobj());
            }
            Criterion authCrt = Restrictions.in((String)"authobj", (Object[])authObjCodes.toArray());
            funAuths.addAll(this.findByCriteria(TmFunAuthEntity.class, authCrt));
        }
        return funAuths;
    }

    @Override
    public List<TmDictDataVo> getTmFunAuthValueByRoleFunc(String roleId, String funcId, String authObj) {
        TmRoleFunctionEntity functionEntity = null;
        List<TmDictDataEntity> dictDatas = this.getTmDictData("authobj", authObj);
        SimpleExpression cr1 = Restrictions.eq((String)"tmRole.id", (Object)roleId);
        SimpleExpression cr2 = Restrictions.eq((String)"tmFunction.id", (Object)funcId);
        List<TmRoleFunctionEntity> functionEntitys = this.findByCriteria(TmRoleFunctionEntity.class, new Criterion[]{cr1, cr2});
        if (!CollectionUtils.isEmpty(functionEntitys)) {
            functionEntity = functionEntitys.get(0);
        }
        String hql = "from TmRoleFuncAuthobjEntity where tmRoleFunction.id=? and authobj=?";
        List<TmRoleFuncAuthobjEntity> authobjVlues = this.findByHql(hql, functionEntity.getId(), authObj);
        List dataVos = Lists.transform(dictDatas, (Function)new TmDictDataEntityToTmDictDataVo(authobjVlues));
        return dataVos;
    }

    @Override
    public void saveFunAuthValue(String roleId, String funcId, String authObj, String authCodes) {
        String hql = "from TmRoleFunctionEntity where tmRole.id=? and tmFunction.id=?";
        List roleFuncs = this.findByHql(hql, roleId, funcId);
        if (!CollectionUtils.isEmpty(roleFuncs) && roleFuncs.size() > 0) {
            TmRoleFunctionEntity roleFunctionEntity = (TmRoleFunctionEntity)roleFuncs.get(0);
            String sql = "delete from tm_r_role_func_authobj where role_function_id=? and authobj=?";
            this.executeSql(sql, roleFunctionEntity.getId(), authObj);
            TmRoleFuncAuthobjEntity authobjEntity = null;
            if (StringUtil.isNotEmpty((String)authCodes)) {
                for (String authCode : authCodes.split(",")) {
                    authobjEntity = new TmRoleFuncAuthobjEntity();
                    authobjEntity.setTmRoleFunction(roleFunctionEntity);
                    authobjEntity.setAuthobj(authObj);
                    authobjEntity.setAuthobjValue(authCode);
                    this.save(authobjEntity);
                }
            }
        }
    }
}

