/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.mdm.dict.util;

import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.redis.cache.IRedisDictCacheService;
import com.biz.eisp.base.core.redis.util.RedisUtils;
import com.biz.eisp.mdm.dict.entity.TmDictDataEntity;
import com.biz.eisp.mdm.dict.entity.TmDictTypeEntity;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DictUtil {
    public static Map<String, TmDictTypeEntity> allDictType = new HashMap<String, TmDictTypeEntity>();
    public static Map<String, List<TmDictDataEntity>> allDictData = new HashMap<String, List<TmDictDataEntity>>();

    public static String getDictDataValueByCode(String typeCode, String dataCode) {
        String dataValue = "";
        IRedisDictCacheService redisDictCacheService = RedisUtils.getIRedisDictCacheService();
        if (redisDictCacheService != null) {
            dataValue = redisDictCacheService.getDictDataValueByCode(typeCode, dataCode);
        } else {
            List<TmDictDataEntity> dictDatas = allDictData.get(typeCode);
            if (CollectionUtil.listNotEmptyNotSizeZero(dictDatas)) {
                for (TmDictDataEntity tmDictDataEntity : dictDatas) {
                    if (!dataCode.equals(tmDictDataEntity.getDictCode())) continue;
                    dataValue = tmDictDataEntity.getDictValue();
                }
            }
        }
        return dataValue;
    }

    public static String getDictCodeByValue(String typeCode, String dataValue) {
        String dataCode = "";
        IRedisDictCacheService redisDictCacheService = RedisUtils.getIRedisDictCacheService();
        if (redisDictCacheService != null) {
            dataCode = redisDictCacheService.getDictCodeByValue(typeCode, dataValue);
        } else {
            List<TmDictDataEntity> dictDatas = allDictData.get(typeCode);
            if (CollectionUtil.listNotEmptyNotSizeZero(dictDatas)) {
                for (TmDictDataEntity tmDictDataEntity : dictDatas) {
                    if (!dataValue.trim().equals(tmDictDataEntity.getDictValue())) continue;
                    dataCode = tmDictDataEntity.getDictCode();
                }
            }
        }
        return dataCode;
    }

    public static String getDictDatasByCodes(String typeCode, String dataValues) {
        String dataCodes = "";
        IRedisDictCacheService redisDictCacheService = RedisUtils.getIRedisDictCacheService();
        if (redisDictCacheService != null) {
            dataCodes = redisDictCacheService.getDictDatasByCodes(typeCode, dataValues);
        } else if (StringUtil.isNotEmpty((String)dataValues)) {
            if (dataValues.indexOf(",") != -1) {
                for (String value : dataValues.split(",")) {
                    if (StringUtil.isNotEmpty((String)dataCodes)) {
                        dataCodes = dataCodes + ",";
                    }
                    dataCodes = dataCodes + DictUtil.getDictDataValueByCode(typeCode, value);
                }
            } else {
                dataCodes = dataCodes + DictUtil.getDictDataValueByCode(typeCode, dataValues);
            }
        }
        return dataCodes;
    }

    public static TmDictDataEntity getDicData(String typeCode, String dataCode) {
        TmDictDataEntity data = null;
        IRedisDictCacheService redisDictCacheService = RedisUtils.getIRedisDictCacheService();
        if (redisDictCacheService != null) {
            data = redisDictCacheService.getDicData(typeCode, dataCode);
        } else {
            List<TmDictDataEntity> dictDatas = allDictData.get(typeCode);
            if (CollectionUtil.listNotEmptyNotSizeZero(dictDatas)) {
                for (TmDictDataEntity tmDictDataEntity : dictDatas) {
                    if (!dataCode.equals(tmDictDataEntity.getDictCode())) continue;
                    data = tmDictDataEntity;
                }
            }
        }
        return data;
    }

    public static String getDicDataValue(String typeCode, String dataCode) {
        String dataVal = null;
        IRedisDictCacheService redisDictCacheService = RedisUtils.getIRedisDictCacheService();
        if (redisDictCacheService != null) {
            dataVal = redisDictCacheService.getDicDataValue(typeCode, dataCode);
        } else {
            List<TmDictDataEntity> dictDatas = allDictData.get(typeCode);
            if (CollectionUtil.listNotEmptyNotSizeZero(dictDatas)) {
                for (TmDictDataEntity tmDictDataEntity : dictDatas) {
                    if (!dataCode.equals(tmDictDataEntity.getDictCode())) continue;
                    dataVal = tmDictDataEntity.getDictValue();
                }
            }
        }
        return dataVal;
    }
}

