SELECT * FROM 
 (SELECT
  hpi.id_ AS ID,
  hpi.proc_def_id_ AS processDefinitionId,
  pd.key_ AS processDefinitionKey,
  pd.name_ AS processDefinitionName,
  hpi.proc_inst_id_ AS processInstanceId,
  bo.process_title AS processTitle,
  bo.full_name AS startFullName,
  to_char(hpi.start_time_,'yyyy-mm-dd hh24:mi:ss') AS startTime,
  CASE WHEN t.suspension_state_ = 2 THEN to_char(t.create_time_, 'yyyy-mm-dd hh24:mi:ss') ELSE to_char(hpi.end_time_,'yyyy-mm-dd hh24:mi:ss') END AS endTime,
  to_char(t.create_time_,'yyyy-mm-dd hh24:mi:ss') AS preNodetime,
  CASE WHEN t.suspension_state_ = 2 THEN 'reject' WHEN hpi.delete_reason_ = 'recover'  THEN 'recover' ELSE rs.code END AS runtimeStatus
FROM
  act_hi_procinst hpi    
  LEFT JOIN act_re_procdef pd ON pd.id_ = hpi.proc_def_id_ 
  LEFT JOIN ta_base_business_obj bo ON bo.id = hpi.business_key_
  LEFT JOIN ta_runtime_status rs ON rs.id = bo.runtime_status_id
  LEFT JOIN (
       SELECT t.proc_inst_id_, t.suspension_state_,max(t.create_time_) AS create_time_ FROM act_ru_task  t GROUP BY t.proc_inst_id_, t.suspension_state_
  ) t ON t.proc_inst_id_ = hpi.id_
<#if myInstanceVo.handleRead ?exists && myInstanceVo.handleRead ?length gt 0>
  left join ta_reject_read rr on rr.proc_inst_id = hpi.id_
</#if>
WHERE
  
<#if myInstanceVo.handleRead ?exists && myInstanceVo.handleRead ?length gt 0>
	 rr.id is null 
</#if>
    AND hpi.start_user_id_ = '${myInstanceVo.startPositionCode}'
<#if myInstanceVo.id ?exists && myInstanceVo.id ?length gt 0>
	AND hpi.id_ LIKE '%${myInstanceVo.id}%'
</#if>
<#if myInstanceVo.processDefinitionKey ?exists && myInstanceVo.processDefinitionKey ?length gt 0>
	AND pd.key_ LIKE '%${myInstanceVo.processDefinitionKey}%'
</#if>
<#if myInstanceVo.processDefinitionName ?exists && myInstanceVo.processDefinitionName ?length gt 0>
	AND pd.name_ LIKE '%${myInstanceVo.processDefinitionName}%'
</#if>
<#if myInstanceVo.processTitle ?exists && myInstanceVo.processTitle ?length gt 0>
	AND bo.process_title LIKE '%${myInstanceVo.processTitle}%'
</#if>
<#if myInstanceVo.processInstanceId ?exists && myInstanceVo.processInstanceId ?length gt 0>
	AND hpi.id_  LIKE '%${myInstanceVo.processInstanceId}%'
</#if>
<#if myInstanceVo.startTime ?exists && myInstanceVo.startTime ?length gt 0>
	AND to_char(hpi.start_time_,'yyyy-mm-dd')  = '${myInstanceVo.startTime}'
</#if>
) t 
<#if myInstanceVo.runtimeStatus ?exists && myInstanceVo.runtimeStatus ?length gt 0>
	WHERE t.runtimeStatus = '${myInstanceVo.runtimeStatus}'
</#if>
ORDER BY t.startTime DESC 