/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.utils;

import freemarker.cache.TemplateLoader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class StringTemplateLoader
implements TemplateLoader {
    private static final String DEFAULT_TEMPLATE_KEY = "_default_template_key";
    private Map templates = new ConcurrentHashMap();

    public StringTemplateLoader(String defaultTemplate) {
        if (defaultTemplate != null && !defaultTemplate.equals("")) {
            this.templates.put(DEFAULT_TEMPLATE_KEY, defaultTemplate);
        }
    }

    public void AddTemplate(String name, String template) {
        if (name == null || template == null || name.equals("") || template.equals("")) {
            return;
        }
        if (!this.templates.containsKey(name)) {
            this.templates.put(name, template);
        }
    }

    public StringTemplateLoader() {
    }

    public void putTemplate(String name, String templateSource) {
        this.putTemplate(name, templateSource, System.currentTimeMillis());
    }

    public void putTemplate(String name, String templateSource, long lastModified) {
        this.templates.put(name, new StringTemplateSource(name, templateSource, lastModified));
    }

    public void closeTemplateSource(Object templateSource) {
    }

    public Object findTemplateSource(String name) {
        return this.templates.get(name);
    }

    public long getLastModified(Object templateSource) {
        return ((StringTemplateSource)templateSource).lastModified;
    }

    public Reader getReader(Object templateSource, String encoding) {
        return new StringReader(((StringTemplateSource)templateSource).source);
    }

    private static class StringTemplateSource {
        private final String name;
        private final String source;
        private final long lastModified;

        StringTemplateSource(String name, String source, long lastModified) {
            if (name == null) {
                throw new IllegalArgumentException("name == null");
            }
            if (source == null) {
                throw new IllegalArgumentException("source == null");
            }
            if (lastModified < -1L) {
                throw new IllegalArgumentException("lastModified < -1L");
            }
            this.name = name;
            this.source = source;
            this.lastModified = lastModified;
        }

        public boolean equals(Object obj) {
            return obj instanceof StringTemplateSource ? this.name.equals(((StringTemplateSource)obj).name) : false;
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }
}

