SELECT
  c.id,
  p.position_code,
  p.position_name,
  u.username,
  u.fullname,
  o.org_code,
  o.org_name
FROM ta_copy c
  LEFT JOIN tm_position p ON p.position_code = c.copy_code
  LEFT JOIN tm_r_user_position up ON up.position_id = p.id AND up.is_main = 0
  LEFT JOIN tm_org o ON o.id = p.org_id
  LEFT JOIN tm_user u ON u.id = up.user_id
WHERE c.process_instance_id = :vo.processInstanceId
<#if vo.positionCode ?exists && vo.positionCode ?length gt 0>
	AND p.position_code LIKE '%${vo.positionCode}%'
</#if>
<#if vo.positionName ?exists && vo.positionName ?length gt 0>
	AND p.position_name LIKE '%${vo.positionName}%'
</#if>
<#if vo.username ?exists && vo.username ?length gt 0>
	AND u.username LIKE '%${vo.username}%'
</#if>
<#if vo.fullname ?exists && vo.fullname ?length gt 0>
	AND u.fullname LIKE '%${vo.fullname}%'
</#if>
<#if vo.orgCode ?exists && vo.orgCode ?length gt 0>
	AND o.org_code LIKE '%${vo.orgCode}%'
</#if>
<#if vo.orgName ?exists && vo.orgName ?length gt 0>
	AND o.org_name LIKE '%${vo.orgName}%'
</#if>
ORDER BY p.position_code