/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.mdm.custuser.controller;

import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.page.EuPage;
import com.biz.eisp.base.core.web.BaseController;
import com.biz.eisp.log.vo.TmLogVo;
import com.biz.eisp.mdm.custuser.service.TmCustUserFormExtendService;
import com.biz.eisp.mdm.custuser.service.TmCustUserMainExtendService;
import com.biz.eisp.mdm.custuser.service.TmCustUserService;
import com.biz.eisp.mdm.user.vo.TmCustUserVo;
import com.biz.eisp.mdm.user.vo.TmUserVo;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/tmCustUserController"})
public class TmCustUserController
extends BaseController {
    @Autowired
    private TmCustUserService tmCustUserService;
    @Autowired(required=false)
    private TmCustUserFormExtendService tmCustUserFormExtendService;
    @Autowired(required=false)
    private TmCustUserMainExtendService tmCustUserMainExtendService;

    @RequestMapping(params={"goTmCustUserMain"})
    public ModelAndView goTmCustUserMain(HttpServletRequest request) {
        request.setAttribute("extendTableName", (Object)Globals.TABLE_USER);
        if (this.tmCustUserMainExtendService != null) {
            request.setAttribute("includeJsp", (Object)this.tmCustUserMainExtendService.includeJsp());
        }
        return new ModelAndView("com/biz/eisp/mdm/tmCustUser/tmCustUserMain");
    }

    @RequestMapping(params={"goTmCustUserForm"})
    public ModelAndView goTmCustUserForm(TmUserVo tmUserVo, HttpServletRequest request, HttpServletResponse response) {
        if (StringUtil.isNotEmpty((String)tmUserVo.getId())) {
            tmUserVo.setUserType(Globals.CUST_USER);
            TmCustUserVo userVo = this.tmCustUserService.findTmCustUserById(tmUserVo);
            if (StringUtil.isNotEmpty(userVo)) {
                userVo.setPassword("******");
                request.setAttribute("vo", (Object)userVo);
            }
        }
        String optype = request.getParameter("optype");
        request.setAttribute("optype", (Object)optype);
        request.setAttribute("extendTableName", (Object)Globals.TABLE_USER);
        if (this.tmCustUserFormExtendService != null) {
            request.setAttribute("includeJsp", (Object)this.tmCustUserFormExtendService.includeJsp());
        }
        return new ModelAndView("com/biz/eisp/mdm/tmCustUser/tmCustUserForm");
    }

    @RequestMapping(params={"findTmCustUserList"})
    public void findTmCustUserList(TmUserVo tmUserVo, HttpServletRequest request, HttpServletResponse response) {
        EuPage page = new EuPage(request);
        List<TmCustUserVo> tmUserVoList = this.tmCustUserService.findTmCustUserList(tmUserVo, page);
        this.datagridReturn(response, tmUserVoList, page);
    }

    @RequestMapping(params={"saveTmUser"})
    @ResponseBody
    public AjaxJson saveTmUser(TmUserVo tmUserVo, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        try {
            EuPage page = new EuPage(request);
            tmUserVo.setUserType(Globals.CUST_USER);
            this.tmCustUserService.saveTmUser(tmUserVo, page);
        }
        catch (Exception e) {
            j.setSuccess(false);
            j.setMsg("\u64cd\u4f5c\u5931\u8d25");
            e.printStackTrace();
        }
        return j;
    }

    @RequestMapping(params={"startOrStopTmuser"})
    @ResponseBody
    public AjaxJson startOrStopTmuser(TmUserVo tmUserVo) {
        AjaxJson json = new AjaxJson();
        try {
            json = this.tmCustUserService.startOrStopTmuser(tmUserVo);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        return json;
    }

    @RequestMapping(params={"goChangeTmUserPassword"})
    public ModelAndView goChangeTmUserPassword(HttpServletRequest request) {
        return new ModelAndView("com/biz/eisp/mdm/tmUser/changeTmPassword");
    }

    @RequestMapping(params={"goTmLogDetailMain"})
    public ModelAndView goTmLogDetailMain(HttpServletRequest request) {
        String businessId = request.getParameter("id");
        request.setAttribute("actionUrl", (Object)("tmCustUserController.do?findTmLogList&businessId=" + businessId));
        return new ModelAndView("com/biz/eisp/log/tmLogDetailMain");
    }

    @RequestMapping(params={"findTmLogList"})
    public void findTmLogList(TmLogVo tmLogVo, HttpServletRequest request, HttpServletResponse response) {
        EuPage page = new EuPage(request);
        List<TmLogVo> tmLogList = this.tmCustUserService.findCustUserLogList(tmLogVo, page);
        this.datagridReturn(response, tmLogList, page);
    }

    @RequestMapping(params={"exportXls"})
    public void exportXls(TmUserVo tmUserVo, HttpServletRequest request, HttpServletResponse response) {
        List<TmCustUserVo> tmUserVoList = this.tmCustUserService.findTmCustUserList(tmUserVo, null);
        this.doExportXls(response, request, tmUserVoList, TmCustUserVo.class, "\u7ecf\u9500\u5546\u7528\u6237\u5217\u8868");
    }
}

