/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.mdm.product.transformer;

import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.mdm.product.entity.TmProductEntity;
import com.biz.eisp.mdm.product.service.TmProductService;
import com.biz.eisp.mdm.product.vo.TmProductVo;
import com.google.common.base.Function;
import java.io.Serializable;
import jodd.util.StringUtil;

public class TmProductVoToTmProductEntity
implements Function<TmProductVo, TmProductEntity> {
    private TmProductService productService;

    public TmProductVoToTmProductEntity(TmProductService productService) {
        this.productService = productService;
    }

    public TmProductEntity apply(TmProductVo vo) {
        if (vo == null) {
            return null;
        }
        TmProductEntity tmProductEntity = null;
        tmProductEntity = StringUtil.isNotEmpty((String)vo.getId()) ? this.productService.get(TmProductEntity.class, (Serializable)((Object)vo.getId())) : new TmProductEntity();
        if (StringUtil.isNotEmpty((String)vo.getProductName())) {
            if (this.productService.validate(vo.getId(), vo.getProductName(), "productName")) {
                // empty if block
            }
        } else {
            throw new BusinessException("\u4ea7\u54c1\u5c42\u7ea7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isNotEmpty((String)vo.getProductCode())) {
            if (this.productService.validate(vo.getId(), vo.getProductCode(), "productCode")) {
                throw new BusinessException("\u8f6c\u6362\u4ea7\u54c1\u5c42\u7ea7Vo\u5230Po\u65f6\uff0c\u4ea7\u54c1\u5c42\u7ea7" + vo.getProductCode() + "\u5df2\u5b58\u5728");
            }
        } else {
            throw new BusinessException("\u4ea7\u54c1\u5c42\u7ea7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            this.copyProperties(vo, tmProductEntity);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (StringUtil.isNotBlank((String)vo.getParentId())) {
            TmProductEntity parnet = this.productService.get(TmProductEntity.class, (Serializable)((Object)vo.getParentId()));
            if (parnet == null) {
                // empty if block
            }
            tmProductEntity.setProduct(parnet);
        }
        tmProductEntity.setEnableStatus(Globals.ZERO);
        return tmProductEntity;
    }

    public void copyProperties(TmProductVo vo, TmProductEntity entity) {
        entity.setEnableStatus(vo.getEnableStatus());
        entity.setProductAttribute1(vo.getProductAttribute1());
        entity.setProductAttribute2(vo.getProductAttribute2());
        entity.setProductAttribute3(vo.getProductAttribute3());
        entity.setProductAttribute4(vo.getProductAttribute4());
        entity.setProductCode(vo.getProductCode());
        entity.setProductLevel(vo.getProductLevel());
        entity.setProductName(vo.getProductName());
        entity.setRemark(vo.getRemark());
    }
}

