/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.behavior;

import com.biz.eisp.activiti.designer.processconf.entity.TaProcessNodeProEntity;
import com.biz.eisp.activiti.designer.processconf.service.TaProcessNodeService;
import com.biz.eisp.activiti.runtime.entity.TaProcessApprovalLogEntity;
import com.biz.eisp.activiti.runtime.service.TaTaskService;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.ResourceUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.utils.ApplicationContextUtils;
import com.biz.eisp.mdm.user.entity.TmUserEntity;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.Expression;
import org.activiti.engine.delegate.VariableScope;
import org.activiti.engine.impl.bpmn.behavior.TaskActivityBehavior;
import org.activiti.engine.impl.calendar.BusinessCalendar;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.IdentityLinkEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;
import org.activiti.engine.impl.task.TaskDefinition;
import org.apache.commons.lang.StringUtils;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class UserTaskActivityBehavior
extends TaskActivityBehavior {
    protected TaskDefinition taskDefinition;

    public UserTaskActivityBehavior(TaskDefinition taskDefinition) {
        this.taskDefinition = taskDefinition;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute(ActivityExecution execution) throws Exception {
        Object category;
        Object priority;
        Object dueDate;
        TaskEntity task = TaskEntity.createAndInsert((ActivityExecution)execution);
        task.setExecution((DelegateExecution)execution);
        task.setTaskDefinition(this.taskDefinition);
        if (this.taskDefinition.getNameExpression() != null) {
            String name = (String)this.taskDefinition.getNameExpression().getValue((VariableScope)execution);
            task.setName(name);
        }
        if (this.taskDefinition.getDescriptionExpression() != null) {
            String description = (String)this.taskDefinition.getDescriptionExpression().getValue((VariableScope)execution);
            task.setDescription(description);
        }
        if (this.taskDefinition.getDueDateExpression() != null && (dueDate = this.taskDefinition.getDueDateExpression().getValue((VariableScope)execution)) != null) {
            if (dueDate instanceof Date) {
                task.setDueDate((Date)dueDate);
            } else {
                if (!(dueDate instanceof String)) throw new ActivitiIllegalArgumentException("Due date expression does not resolve to a Date or Date string: " + this.taskDefinition.getDueDateExpression().getExpressionText());
                BusinessCalendar businessCalendar = Context.getProcessEngineConfiguration().getBusinessCalendarManager().getBusinessCalendar("dueDate");
                task.setDueDate(businessCalendar.resolveDuedate((String)dueDate));
            }
        }
        if (this.taskDefinition.getPriorityExpression() != null && (priority = this.taskDefinition.getPriorityExpression().getValue((VariableScope)execution)) != null) {
            if (priority instanceof String) {
                try {
                    task.setPriority(Integer.valueOf((String)priority).intValue());
                }
                catch (NumberFormatException e) {
                    throw new ActivitiIllegalArgumentException("Priority does not resolve to a number: " + priority, (Throwable)e);
                }
            } else {
                if (!(priority instanceof Number)) throw new ActivitiIllegalArgumentException("Priority expression does not resolve to a number: " + this.taskDefinition.getPriorityExpression().getExpressionText());
                task.setPriority(((Number)priority).intValue());
            }
        }
        if (this.taskDefinition.getCategoryExpression() != null && (category = this.taskDefinition.getCategoryExpression().getValue((VariableScope)execution)) != null) {
            if (!(category instanceof String)) throw new ActivitiIllegalArgumentException("Category expression does not resolve to a string: " + this.taskDefinition.getCategoryExpression().getExpressionText());
            task.setCategory((String)category);
        }
        this.handleAssignments(task, execution);
        task.fireEvent("create");
        String assignPositionCodes = this.findAssignPositionCodes(task);
        String version = task.getProcessDefinitionId();
        TaProcessNodeService taProcessNodeService = (TaProcessNodeService)ApplicationContextUtils.getContext().getBean(TaProcessNodeService.class);
        TaProcessNodeProEntity processNodeEntity = taProcessNodeService.getTaProcessNodeByVersionKey(task.getProcessDefinitionId(), task.getProcessInstance().getProcessDefinition().getKey());
        if (StringUtils.isBlank((String)assignPositionCodes)) {
            if (processNodeEntity == null) return;
            String nullJumpNode = processNodeEntity.getNullJumpNode();
            if (!StringUtils.isNotBlank((String)nullJumpNode) || !"Y".equals(nullJumpNode)) throw new BusinessException("\u6d41\u7a0b\u8282\u70b9'" + processNodeEntity.getProcessNodeName() + "'\u6ca1\u6709\u627e\u5230\u4efb\u52a1\u6307\u6d3e\u4eba\uff0c\u8bf7\u914d\u7f6e");
            this.saveApproveLog(task, "\u7a7a\u8282\u70b9\u8df3\u8fc7");
            task.complete();
            return;
        } else {
            String duplicateJumpNode;
            boolean isDuplicateApprove = this.isDuplicateApprove(task, assignPositionCodes);
            if (!isDuplicateApprove || processNodeEntity == null || !StringUtil.isNotBlank((String)(duplicateJumpNode = processNodeEntity.getDuplicateJumpNode())) || !"Y".equals(duplicateJumpNode)) return;
            this.saveApproveLog(task, "\u91cd\u590d\u901a\u8fc7");
            task.complete();
        }
    }

    private boolean isDuplicateApprove(TaskEntity task, String assignPositionCodes) {
        String procInstId = task.getProcessInstanceId();
        String[] strCodes = assignPositionCodes.split(",");
        String sql = "SELECT * FROM ACT_HI_TASKINST WHERE PROC_INST_ID_ = :procInstId AND OWNER_ IN (:assignPositionCodes)";
        NamedParameterJdbcTemplate named = (NamedParameterJdbcTemplate)ApplicationContextUtils.getContext().getBean(NamedParameterJdbcTemplate.class);
        MapSqlParameterSource paramMap = new MapSqlParameterSource();
        paramMap.addValue("procInstId", (Object)procInstId);
        paramMap.addValue("assignPositionCodes", Arrays.asList(strCodes));
        List list = named.queryForList(sql, (SqlParameterSource)paramMap);
        return CollectionUtil.listNotEmptyNotSizeZero(list);
    }

    public void signal(ActivityExecution execution, String signalName, Object signalData) throws Exception {
        if (((ExecutionEntity)execution).getTasks().size() != 0) {
            throw new ActivitiException("UserTask should not be signalled before complete");
        }
        this.leave(execution);
    }

    protected void handleAssignments(TaskEntity task, ActivityExecution execution) {
        List<String> candiates;
        Object value;
        if (this.taskDefinition.getAssigneeExpression() != null) {
            task.setAssignee((String)this.taskDefinition.getAssigneeExpression().getValue((VariableScope)execution), true, false);
        }
        if (this.taskDefinition.getOwnerExpression() != null) {
            task.setOwner((String)this.taskDefinition.getOwnerExpression().getValue((VariableScope)execution));
        }
        if (!this.taskDefinition.getCandidateGroupIdExpressions().isEmpty()) {
            for (Expression groupIdExpr : this.taskDefinition.getCandidateGroupIdExpressions()) {
                value = groupIdExpr.getValue((VariableScope)execution);
                if (value instanceof String) {
                    candiates = this.extractCandidates((String)value);
                    task.addCandidateGroups(candiates);
                    continue;
                }
                if (value instanceof Collection) {
                    task.addCandidateGroups((Collection)value);
                    continue;
                }
                throw new ActivitiIllegalArgumentException("Expression did not resolve to a string or collection of strings");
            }
        }
        if (!this.taskDefinition.getCandidateUserIdExpressions().isEmpty()) {
            for (Expression userIdExpr : this.taskDefinition.getCandidateUserIdExpressions()) {
                value = userIdExpr.getValue((VariableScope)execution);
                if (value instanceof String) {
                    candiates = this.extractCandidates((String)value);
                    task.addCandidateUsers(candiates);
                    continue;
                }
                if (value instanceof Collection) {
                    task.addCandidateUsers((Collection)value);
                    continue;
                }
                throw new ActivitiException("Expression did not resolve to a string or collection of strings");
            }
        }
    }

    private String findAssignPositionCodes(TaskEntity task) {
        String assignPositionCodes = "";
        if (StringUtils.isNotBlank((String)task.getAssignee())) {
            assignPositionCodes = task.getAssignee();
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(task.getIdentityLinks())) {
            for (IdentityLinkEntity identityLinkEntity : task.getIdentityLinks()) {
                assignPositionCodes = assignPositionCodes + identityLinkEntity.getUserId() + ",";
            }
            assignPositionCodes = assignPositionCodes.substring(0, assignPositionCodes.length() - 1);
        }
        return assignPositionCodes;
    }

    private void saveApproveLog(TaskEntity task, String content) {
        TmUserEntity user = ResourceUtil.getClient().getUser();
        TaProcessApprovalLogEntity log = new TaProcessApprovalLogEntity();
        log.setCreateDate(new Date());
        log.setAccount(user.getUserName());
        log.setContent(content);
        log.setName(user.getFullName());
        log.setProcessInstId(task.getProcessInstanceId());
        log.setPositionCode(ResourceUtil.getCurrPosition().getPositionCode());
        log.setPositionName(ResourceUtil.getCurrPosition().getPositionName());
        log.setTaskDefKey(this.taskDefinition.getKey());
        log.setType(1);
        TaTaskService taTaskService = (TaTaskService)ApplicationContextUtils.getContext().getBean(TaTaskService.class);
        taTaskService.save(log);
    }

    protected List<String> extractCandidates(String str) {
        return Arrays.asList(str.split("[\\s]*,[\\s]*"));
    }

    public TaskDefinition getTaskDefinition() {
        return this.taskDefinition;
    }
}

