/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.activiti.designer.businessconf.controller;

import com.biz.eisp.activiti.designer.businessconf.entity.TaBusinessObjEntity;
import com.biz.eisp.activiti.designer.businessconf.entity.TaProcessBusinessObjConfigEntity;
import com.biz.eisp.activiti.designer.businessconf.service.TaBusinessObjService;
import com.biz.eisp.activiti.designer.businessconf.service.TaProcessBusinessObjConfigService;
import com.biz.eisp.activiti.designer.businessconf.transformer.TaProcessBusinessObjConfigEntityToVo;
import com.biz.eisp.activiti.designer.businessconf.transformer.TaProcessBusinessObjConfigVoToEntity;
import com.biz.eisp.activiti.designer.businessconf.vo.TaBusinessObjVo;
import com.biz.eisp.activiti.designer.businessconf.vo.TaProcessBusinessObjConfigVo;
import com.biz.eisp.activiti.designer.processconf.entity.TaProcessEntity;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.jsonmodel.ValidForm;
import com.biz.eisp.base.common.util.OConvertUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.page.EuPage;
import com.biz.eisp.base.core.web.BaseController;
import java.io.Serializable;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/taProcessBusinessObjConfigController"})
public class TaProcessBusinessObjConfigController
extends BaseController {
    @Autowired
    private TaProcessBusinessObjConfigService configService;
    @Autowired
    private TaBusinessObjService businessService;

    @RequestMapping(params={"goConfigMain"})
    public ModelAndView goConfigMain(String taProcessId) {
        ModelAndView view = new ModelAndView("com/biz/eisp/activiti/designer/businessconf/taProcessBusinessObjConfigMain");
        view.addObject("taProcessId", (Object)taProcessId);
        return view;
    }

    @RequestMapping(params={"goConfigForm"})
    public ModelAndView goConfigForm(String id, String taProcessId) {
        ModelAndView view = new ModelAndView("com/biz/eisp/activiti/designer/businessconf/taProcessBusinessObjConfigForm");
        if (StringUtils.isNotBlank((CharSequence)id)) {
            TaProcessBusinessObjConfigEntity entity = this.configService.get(TaProcessBusinessObjConfigEntity.class, (Serializable)((Object)id));
            TaProcessBusinessObjConfigVo vo = new TaProcessBusinessObjConfigEntityToVo().apply(entity);
            view.addObject("configVo", (Object)vo);
        }
        List<TaBusinessObjVo> taBusinessObjVo = this.findAllBusinessObj();
        view.addObject("taProcessId", (Object)taProcessId);
        view.addObject("taBusinessObjVos", taBusinessObjVo);
        return view;
    }

    @RequestMapping(params={"findConfigList"})
    @ResponseBody
    public DataGrid findConfigList(String taProcessId, HttpServletRequest request) {
        EuPage page = new EuPage(request);
        List<TaProcessBusinessObjConfigVo> list = this.configService.findConfigByProcessId(taProcessId, page);
        return new DataGrid(list, page);
    }

    @RequestMapping(params={"saveOrUpdateConfig"})
    @ResponseBody
    public AjaxJson saveOrUpdateConfig(TaProcessBusinessObjConfigVo vo) {
        AjaxJson aj = new AjaxJson();
        String message = null;
        TaProcessBusinessObjConfigEntity entity = new TaProcessBusinessObjConfigVoToEntity().apply(vo);
        TaBusinessObjEntity objEntity = this.businessService.get(TaBusinessObjEntity.class, (Serializable)((Object)vo.getBusinessObjId()));
        TaProcessEntity pEntity = this.configService.get(TaProcessEntity.class, (Serializable)((Object)vo.getProcessId()));
        entity.setTaBusinessObjEntity(objEntity);
        entity.setTaProcessEntity(pEntity);
        if (vo.getId().equals("")) {
            this.configService.save(entity);
            message = "\u65b0\u589e:" + vo.getBusinessName() + "\u6210\u529f";
        } else {
            this.configService.updateEntity(entity);
            message = "\u66f4\u65b0:" + vo.getBusinessName() + "\u6210\u529f";
        }
        aj.setSuccess(true);
        aj.setMsg(message);
        return aj;
    }

    @RequestMapping(params={"delConfigById"})
    @ResponseBody
    public AjaxJson delConfigById(String id) {
        AjaxJson aj = new AjaxJson();
        if (StringUtils.isNotBlank((CharSequence)id)) {
            TaProcessBusinessObjConfigEntity entity = this.configService.get(TaProcessBusinessObjConfigEntity.class, (Serializable)((Object)id));
            this.configService.delete(entity);
            aj.setMsg("\u5220\u9664\u6210\u529f");
            aj.setSuccess(true);
        }
        return aj;
    }

    public List<TaBusinessObjVo> findAllBusinessObj() {
        return this.businessService.findAllBusinessObj();
    }

    @RequestMapping(params={"validateBusinessName"})
    @ResponseBody
    public ValidForm validateBusinessName(TaProcessBusinessObjConfigVo vo, HttpServletRequest request) {
        String param = OConvertUtils.getString(request.getParameter("param"));
        ValidForm validForm = new ValidForm();
        if (StringUtil.isNotEmpty((String)vo.getId())) {
            SimpleExpression cr1 = Restrictions.eq((String)"businessName", (Object)param);
            SimpleExpression cr2 = Restrictions.ne((String)"id", (Object)vo.getId());
            List<TaProcessBusinessObjConfigEntity> taconfigs = this.configService.findByCriteria(TaProcessBusinessObjConfigEntity.class, new Criterion[]{cr1, cr2});
            if (!CollectionUtils.isEmpty(taconfigs)) {
                validForm.setStatus("n");
                validForm.setInfo("\u4e1a\u52a1\u540d\u79f0\u5df2\u5b58\u5728");
            }
        } else {
            SimpleExpression cr3 = Restrictions.eq((String)"businessName", (Object)param);
            List<TaProcessBusinessObjConfigEntity> taconfigs = this.configService.findByCriteria(TaProcessBusinessObjConfigEntity.class, new Criterion[]{cr3});
            if (!CollectionUtils.isEmpty(taconfigs)) {
                validForm.setStatus("n");
                validForm.setInfo("\u4e1a\u52a1\u540d\u79f0\u5df2\u5b58\u5728");
            }
        }
        return validForm;
    }
}

