/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.activiti.designer.processconf.transformer;

import com.biz.eisp.activiti.designer.processconf.entity.TaProcessEntity;
import com.biz.eisp.activiti.designer.processconf.entity.TaProcessNodeAuthEntity;
import com.biz.eisp.activiti.designer.processconf.entity.TaProcessNodeEntity;
import com.biz.eisp.activiti.designer.processconf.service.TaProcessNodeService;
import com.biz.eisp.activiti.designer.processconf.service.TaProcessService;
import com.biz.eisp.activiti.designer.processconf.vo.TaProcessVo;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.utils.StreamUtils;
import com.biz.eisp.mdm.dict.util.DictUtil;
import com.google.common.base.Function;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class TaProcessVoToTaProcessEntity
implements Function<TaProcessVo, TaProcessEntity> {
    private TaProcessService taProcessService;
    private TaProcessNodeService taProcessNodeService;

    public TaProcessVoToTaProcessEntity(TaProcessService taProcessService, TaProcessNodeService taProcessNodeService) {
        this.taProcessService = taProcessService;
        this.taProcessNodeService = taProcessNodeService;
    }

    public TaProcessEntity apply(TaProcessVo vo) {
        TaProcessEntity entity = null;
        if (vo == null) {
            return null;
        }
        if ("0".equals(vo.getId())) {
            entity = new TaProcessEntity();
            List<TaProcessEntity> list = this.taProcessService.findByProperty(TaProcessEntity.class, "processKey", vo.getProcessKey());
            if (list.size() > 0) {
                throw new BusinessException("\u6d41\u7a0bKey\u91cd\u590d\u4e86");
            }
        } else {
            entity = this.taProcessService.get(TaProcessEntity.class, (Serializable)((Object)vo.getId()));
        }
        entity.setListenerClass(vo.getListenerClass());
        entity.setNote(vo.getNote());
        entity.setProcessKey(vo.getProcessKey());
        entity.setProcessName(vo.getProcessName());
        entity.setProcessState(vo.getProcessState());
        entity.setProcessXml(StreamUtils.StringTObyte(vo.getProcessDescriptor()));
        entity.setRedirectUrl(vo.getRedirectUrl());
        entity.setTableName(vo.getTableName());
        this.taProcessService.save(entity);
        String nodes = vo.getNodes();
        HashMap newMap = new HashMap();
        if (StringUtils.isNotBlank((CharSequence)nodes)) {
            String[] temp = nodes.split("@@@");
            for (int i = 0; i < temp.length; ++i) {
                TaProcessNodeEntity taProcessNodeEntity = null;
                String[] fileds = temp[i].split("###");
                String tid = fileds[0].substring(3);
                String name = fileds[1].substring(9);
                String roleCode = null;
                if (fileds.length > 2) {
                    roleCode = fileds[2].substring(9);
                }
                if ((taProcessNodeEntity = this.taProcessNodeService.getTaProcessNodeEntity(tid, vo.getProcessKey())) == null) {
                    taProcessNodeEntity = new TaProcessNodeEntity();
                    taProcessNodeEntity.setProcessNodeCode(tid);
                    taProcessNodeEntity.setProcessNodeName(name);
                    taProcessNodeEntity.setTaProcessEntity(entity);
                    taProcessNodeEntity.setDuplicateJumpNode("N");
                    taProcessNodeEntity.setNullJumpNode("N");
                    this.taProcessService.save(taProcessNodeEntity);
                } else {
                    taProcessNodeEntity.setProcessNodeCode(tid);
                    taProcessNodeEntity.setProcessNodeName(name);
                    taProcessNodeEntity.setTaProcessEntity(entity);
                    this.taProcessService.updateEntity(taProcessNodeEntity);
                }
                this.saveTaProcessNodeAuth(taProcessNodeEntity);
            }
        }
        return entity;
    }

    private void saveTaProcessNodeAuth(TaProcessNodeEntity taProcessNodeEntity) {
        TaProcessNodeAuthEntity authEntity = this.taProcessService.findUniqueByProperty(TaProcessNodeAuthEntity.class, "processNodeId", taProcessNodeEntity.getId());
        if (authEntity == null) {
            authEntity = new TaProcessNodeAuthEntity();
            authEntity.setProcessNodeId(taProcessNodeEntity.getId());
            authEntity.setProcessId(taProcessNodeEntity.getTaProcessEntity().getId());
            String btn1 = DictUtil.getDicDataValue("tm_process_node_auth", "btn1") == null ? "Y" : DictUtil.getDicDataValue("tm_process_node_auth", "btn1");
            String btn2 = DictUtil.getDicDataValue("tm_process_node_auth", "btn2") == null ? "Y" : DictUtil.getDicDataValue("tm_process_node_auth", "btn2");
            String btn3 = DictUtil.getDicDataValue("tm_process_node_auth", "btn3") == null ? "Y" : DictUtil.getDicDataValue("tm_process_node_auth", "btn3");
            String btn4 = DictUtil.getDicDataValue("tm_process_node_auth", "btn4") == null ? "Y" : DictUtil.getDicDataValue("tm_process_node_auth", "btn4");
            String btn5 = DictUtil.getDicDataValue("tm_process_node_auth", "btn5") == null ? "Y" : DictUtil.getDicDataValue("tm_process_node_auth", "btn5");
            String btn6 = DictUtil.getDicDataValue("tm_process_node_auth", "btn6") == null ? "Y" : DictUtil.getDicDataValue("tm_process_node_auth", "btn6");
            String btn7 = DictUtil.getDicDataValue("tm_process_node_auth", "btn7") == null ? "Y" : DictUtil.getDicDataValue("tm_process_node_auth", "btn7");
            String btn8 = DictUtil.getDicDataValue("tm_process_node_auth", "btn8") == null ? "Y" : DictUtil.getDicDataValue("tm_process_node_auth", "btn8");
            String btn9 = DictUtil.getDicDataValue("tm_process_node_auth", "btn9") == null ? "Y" : DictUtil.getDicDataValue("tm_process_node_auth", "btn9");
            String btn10 = DictUtil.getDicDataValue("tm_process_node_auth", "btn10") == null ? "Y" : DictUtil.getDicDataValue("tm_process_node_auth", "btn10");
            authEntity.setBtn1(btn1);
            authEntity.setBtn2(btn2);
            authEntity.setBtn3(btn3);
            authEntity.setBtn4(btn4);
            authEntity.setBtn5(btn5);
            authEntity.setBtn6(btn6);
            authEntity.setBtn7(btn7);
            authEntity.setBtn8(btn8);
            authEntity.setBtn9(btn9);
            authEntity.setBtn10(btn10);
        }
        this.taProcessService.saveOrUpdate(authEntity);
    }
}

