/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.importer.validator;

import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.importer.DataField;
import com.biz.eisp.base.importer.validator.AbstractValidator;
import com.biz.eisp.base.importer.validator.CharValidator;
import com.biz.eisp.base.importer.validator.DataValidator;
import com.biz.eisp.base.importer.validator.DateValidator;
import com.biz.eisp.base.importer.validator.NumberValidator;
import com.biz.eisp.mdm.config.entity.TmMdmTableConfigEntity;
import com.biz.eisp.mdm.dict.util.DictUtil;
import com.biz.eisp.mdm.dict.vo.TmDictDataVo;
import java.util.List;
import java.util.regex.Pattern;

public class ValidatorFactory {
    public static DataValidator createValidator(DataField field) {
        AbstractValidator v = null;
        if ("char".equals(field.getType().trim())) {
            v = new CharValidator(field);
        } else if ("date".equals(field.getType().trim())) {
            v = new DateValidator(field);
        } else if ("number".equals(field.getType().trim())) {
            v = new NumberValidator(field);
        }
        return v;
    }

    public static String validateDynamicImplData(TmMdmTableConfigEntity tableConfigEntity, Object fieldValue) {
        String errorMsg = "";
        String fieldDesc = "";
        String maskStr = "";
        boolean required = false;
        String dict = "";
        if (tableConfigEntity != null) {
            maskStr = tableConfigEntity.getDataType();
            String string = fieldDesc = StringUtil.isNotEmpty((String)tableConfigEntity.getFormName()) ? tableConfigEntity.getFormName() : tableConfigEntity.getColumnDesc();
            if (tableConfigEntity.getRequired() != null && tableConfigEntity.getRequired() == 1) {
                required = true;
            }
            dict = tableConfigEntity.getDictType();
        }
        if (StringUtil.isNotEmpty(fieldValue)) {
            String validateMsg;
            if (StringUtil.isNotEmpty((String)maskStr) && StringUtil.isNotEmpty((String)(validateMsg = ValidatorFactory.validateForm(fieldValue, maskStr)))) {
                errorMsg = fieldDesc + validateMsg;
            }
        } else if (required) {
            errorMsg = fieldDesc + "\u4e3a\u7a7a";
        }
        if (StringUtil.isNotEmpty((String)dict) && StringUtil.isNotEmpty(fieldValue)) {
            String code = DictUtil.getDictDataValueByCode(dict, fieldValue.toString());
            List<TmDictDataVo> dataList = DictUtil.getDictList(dict);
            if (CollectionUtil.listNotEmptyNotSizeZero(dataList)) {
                if (StringUtil.isEmpty(code)) {
                    errorMsg = errorMsg + fieldDesc + "\u8f93\u5165\u6709\u8bef\uff0c\u6570\u636e\u5b57\u5178[" + dict + "]\u672a\u627e\u5230\u503c" + fieldValue;
                }
            } else {
                errorMsg = errorMsg + "\u672a\u627e\u5230\u6570\u636e\u5b57\u5178" + dict;
            }
        }
        return errorMsg;
    }

    public static String validateForm(Object value, String maskStr) {
        String content = "";
        if (StringUtil.equals(maskStr, "*")) {
            if (StringUtil.isEmpty(value)) {
                content = "\u9a8c\u8bc1\u5931\u8d25\uff0c\u4e0d\u80fd\u4e3a\u7a7a";
            }
        } else if (StringUtil.equals(maskStr, "n")) {
            String numMask = "^[0-9]*$";
            if (!ValidatorFactory.validateMask(value.toString(), numMask)) {
                content = "\u9a8c\u8bc1\u5931\u8d25\uff0c\u6570\u636e\u5e94\u4e3a\u6570\u503c";
            }
        } else {
            maskStr = maskStr.substring(1, maskStr.length() - 1);
            if (!ValidatorFactory.validateMask(value.toString(), maskStr)) {
                content = "\u9a8c\u8bc1\u5931\u8d25\uff0c\u4e0d\u80fd\u901a\u8fc7\u4e3b\u6570\u636e\u914d\u7f6e\u8868\u5355\u9a8c\u8bc1";
            }
        }
        return content;
    }

    private static boolean validateMask(String value, String maskStr) {
        Pattern mask = Pattern.compile(maskStr);
        return mask == null || mask.matcher(value).matches();
    }
}

