/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.activiti.demo.service.impl;

import com.biz.eisp.activiti.common.WorkFlowGlobals;
import com.biz.eisp.activiti.demo.dao.TaLeaveDao;
import com.biz.eisp.activiti.demo.entity.LeaveEntity;
import com.biz.eisp.activiti.demo.service.LeaveService;
import com.biz.eisp.activiti.demo.vo.TaLeaveQueryVo;
import com.biz.eisp.activiti.demo.vo.TaLeaveVo;
import com.biz.eisp.activiti.designer.businessconf.entity.TaProcessBusinessObjConfigEntity;
import com.biz.eisp.activiti.designer.businessconf.service.TaProcessBusinessObjConfigService;
import com.biz.eisp.activiti.runtime.entity.TaRuntimeStatusEntity;
import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.util.ResourceUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;
import com.biz.eisp.mdm.position.entity.TmPositionEntity;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="leaveService")
@Transactional
public class LeaveServiceImpl
extends BaseServiceImpl
implements LeaveService {
    @Autowired
    private TaLeaveDao taLeaveDao;
    @Autowired
    private TaProcessBusinessObjConfigService taProcessBusinessObjConfigService;

    @Override
    public List<TaLeaveQueryVo> findLeaveList(TaLeaveQueryVo taLeaveQueryVo, Page page) {
        return this.taLeaveDao.findLeaveQuery(taLeaveQueryVo, page);
    }

    @Override
    public void saveTaLeave(TaLeaveVo taLeaveVo, Page page) {
        String status;
        String processKey = taLeaveVo.getProcessKey();
        String id = taLeaveVo.getId();
        String processTitle = taLeaveVo.getProcessTitle();
        String content = taLeaveVo.getContent();
        TmPositionEntity positionEntity = this.get(TmPositionEntity.class, (Serializable)((Object)ResourceUtil.getCurrPosition().getId()));
        TaProcessBusinessObjConfigEntity busConfig = this.taProcessBusinessObjConfigService.getTaProcessBusinessObjConfigEntity(LeaveEntity.class, processKey);
        TaRuntimeStatusEntity runTimeStatusEnttiy = this.findUniqueByProperty(TaRuntimeStatusEntity.class, "code", WorkFlowGlobals.RUNTIME_STATUS_NEW);
        LeaveEntity leave = new LeaveEntity();
        if (StringUtils.isNotBlank((CharSequence)id) && StringUtil.equals(status = (leave = this.get(LeaveEntity.class, (Serializable)((Object)id))).getTaRuntimeStatusEntity().getCode(), WorkFlowGlobals.RUNTIME_STATUS_REJECT)) {
            leave.setEnableStatus(Globals.ONE);
            this.updateEntity(leave);
            leave = new LeaveEntity();
            leave.setRefrenceId(id);
        }
        leave.setTaProcessBusinessObjConfigEntity(busConfig);
        leave.setTmPositionEntity(positionEntity);
        leave.setTaRuntimeStatusEntity(runTimeStatusEnttiy);
        leave.setCreatetime(new Date());
        leave.setProcessTitle(processTitle);
        leave.setPositionCode(positionEntity.getPositionCode());
        leave.setPositionName(positionEntity.getPositionName());
        leave.setUserName(ResourceUtil.getSessionUserName().getUserName());
        leave.setFullName(ResourceUtil.getSessionUserName().getFullName());
        leave.setContent(content);
        leave.setEnableStatus(Globals.ZERO);
        this.saveOrUpdate(leave);
    }

    @Override
    public List<TaLeaveQueryVo> findLeaveHisList(TaLeaveQueryVo vo, Page page) {
        return this.taLeaveDao.findLeaveHisList(vo, page);
    }
}

