/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.activiti.designer.businessconf.service.impl;

import com.biz.eisp.activiti.designer.businessconf.entity.TaProcessVariableEntity;
import com.biz.eisp.activiti.designer.businessconf.service.TaProcessVariableService;
import com.biz.eisp.activiti.designer.businessconf.transformer.TaProcessVariableEntityToTaProcessVariableVo;
import com.biz.eisp.activiti.designer.businessconf.transformer.TaProcessVariableVoToTaProcessVariableEntity;
import com.biz.eisp.activiti.designer.businessconf.vo.TaProcessVariableVo;
import com.biz.eisp.activiti.designer.processconf.entity.TaProcessEntity;
import com.biz.eisp.activiti.designer.processconf.entity.TaProcessNodeEntity;
import com.biz.eisp.activiti.designer.processconf.service.TaProcessNodeService;
import com.biz.eisp.activiti.designer.processconf.service.TaProcessService;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="taProcessVariableService")
@Transactional
public class TaProcessVariableServiceImpl
extends BaseServiceImpl
implements TaProcessVariableService {
    @Autowired
    private TaProcessService taProcessService;
    @Autowired
    private TaProcessNodeService taProcessNodeService;

    @Override
    public List<TaProcessVariableVo> getVariableByProcessId(String processId, Page page) {
        String hql = "from TaProcessVariableEntity t where t.taProcessEntity.id = ?";
        List list = this.findByHql(hql, page, processId);
        ArrayList<TaProcessVariableVo> result = new ArrayList<TaProcessVariableVo>();
        for (TaProcessVariableEntity entity : list) {
            TaProcessVariableVo vo = new TaProcessVariableEntityToTaProcessVariableVo().apply(entity);
            result.add(vo);
        }
        return result;
    }

    @Override
    public void saveVariable(TaProcessVariableVo pvVo) {
        TaProcessVariableEntity entity = new TaProcessVariableVoToTaProcessVariableEntity().apply(pvVo);
        String nodeId = pvVo.getNodeId();
        TaProcessNodeEntity nodeEntity = this.taProcessNodeService.get(TaProcessNodeEntity.class, (Serializable)((Object)nodeId));
        String processId = pvVo.getProcessId();
        TaProcessEntity pe = this.taProcessService.get(TaProcessEntity.class, (Serializable)((Object)processId));
        entity.setTaProcessEntity(pe);
        entity.setTaProcessNodeEntity(nodeEntity);
        try {
            if (pvVo.getId().equals("")) {
                this.save(entity);
            } else {
                this.updateEntity(entity);
            }
        }
        catch (Exception e) {
            throw new BusinessException("\u6570\u636e\u5e93\u64cd\u4f5c\u5f02\u5e38");
        }
    }
}

