/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.activiti.designer.processconf.service.impl;

import com.biz.eisp.activiti.designer.processconf.entity.TaProcessNodeAuthProEntity;
import com.biz.eisp.activiti.designer.processconf.entity.TaProcessNodeEntity;
import com.biz.eisp.activiti.designer.processconf.entity.TaProcessNodeProEntity;
import com.biz.eisp.activiti.designer.processconf.service.TaProcessNodeService;
import com.biz.eisp.activiti.designer.processconf.transformer.TaProcessNodeEntityToTaProcessNodeVo;
import com.biz.eisp.activiti.designer.processconf.vo.TaProcessNodeVo;
import com.biz.eisp.base.common.jsonmodel.ValidForm;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="taProcessNodeService")
@Transactional
public class TaProcessNodeServiceImpl
extends BaseServiceImpl
implements TaProcessNodeService {
    @Override
    public TaProcessNodeEntity getTaProcessNodeEntity(String taskDefinitionKey, String processkey) {
        String hql = "from TaProcessNodeEntity t where t.taProcessEntity.processKey = ? and t.processNodeCode = ?";
        List entityList = this.findByHql(hql, processkey, taskDefinitionKey);
        if (entityList != null && entityList.size() > 0) {
            return (TaProcessNodeEntity)entityList.get(0);
        }
        return null;
    }

    @Override
    public List<TaProcessNodeVo> getNodeByProcessId(String processId, Page page) {
        String hql = "from TaProcessNodeEntity t where t.taProcessEntity.id = ? order by t.sort asc";
        List list = this.findByHql(hql, page, processId);
        ArrayList<TaProcessNodeVo> result = new ArrayList<TaProcessNodeVo>();
        for (TaProcessNodeEntity entity : list) {
            TaProcessNodeVo vo = new TaProcessNodeEntityToTaProcessNodeVo().apply(entity);
            result.add(vo);
        }
        return result;
    }

    @Override
    public List<TaProcessNodeVo> getNodeByProcessId(String processId) {
        String hql = "from TaProcessNodeEntity t where t.taProcessEntity.id = ?";
        List list = this.findByHql(hql, processId);
        ArrayList<TaProcessNodeVo> result = new ArrayList<TaProcessNodeVo>();
        for (TaProcessNodeEntity entity : list) {
            TaProcessNodeVo vo = new TaProcessNodeEntityToTaProcessNodeVo().apply(entity);
            result.add(vo);
        }
        return result;
    }

    @Override
    public List<TaProcessNodeEntity> getNodeEntityByProcessId(String processId) {
        String hql = "from TaProcessNodeEntity t where t.taProcessEntity.id = ?";
        List<TaProcessNodeEntity> result = this.findByHql(hql, processId);
        return result;
    }

    @Override
    public ValidForm validateNode(TaProcessNodeVo nodeVo, String param) {
        ValidForm v = new ValidForm();
        if (StringUtil.isNotEmpty((String)nodeVo.getId())) {
            long count;
            String sql;
            if ("1".equals(nodeVo.getFlag())) {
                sql = "select count(1) from ta_process_node where process_node_code=? and id<>?";
                count = this.getCountForJdbcParam(sql, param, nodeVo.getId());
                if (count > 0L) {
                    v.setStatus("n");
                    v.setInfo("\u8282\u70b9\u7f16\u7801\u5df2\u5b58\u5728");
                }
            }
            if ("0".equals(nodeVo.getFlag())) {
                sql = "select count(1) from ta_process_node where process_node_name=? and id<> ? and process_id = ?";
                count = this.getCountForJdbcParam(sql, param, nodeVo.getId(), nodeVo.getTaProcessId());
                if (count > 0L) {
                    v.setStatus("n");
                    v.setInfo("\u8282\u70b9\u540d\u79f0\u5df2\u5b58\u5728");
                }
            }
        } else {
            long count;
            String sql;
            if ("1".equals(nodeVo.getFlag())) {
                sql = "select count(1) from ta_process_node where process_node_code=?";
                count = this.getCountForJdbcParam(sql, param);
                if (count > 0L) {
                    v.setStatus("n");
                    v.setInfo("\u8282\u70b9\u7f16\u7801\u5df2\u5b58\u5728");
                }
            }
            if ("0".equals(nodeVo.getFlag())) {
                sql = "select count(1) from ta_process_node where process_node_name=?";
                count = this.getCountForJdbcParam(sql, param);
                if (count > 0L) {
                    v.setStatus("n");
                    v.setInfo("\u8282\u70b9\u540d\u79f0\u5df2\u5b58\u5728");
                }
            }
        }
        return v;
    }

    @Override
    public TaProcessNodeProEntity getTaProcessNodeByVersionKey(String processVersion, String taskDefinitionKey) {
        String hql = "from TaProcessNodeProEntity t where t.procDefId = ? and t.processNodeCode = ?";
        List entityList = this.findByHql(hql, processVersion, taskDefinitionKey);
        if (entityList != null && entityList.size() > 0) {
            return (TaProcessNodeProEntity)entityList.get(0);
        }
        return null;
    }

    @Override
    public TaProcessNodeAuthProEntity getTaProcessNodeAuthEntity(String processVersion, String processNodeId) {
        String hql = "from TaProcessNodeAuthProEntity t where t.procDefId = ? and t.processNodeId = ?";
        List entityList = this.findByHql(hql, processVersion, processNodeId);
        if (entityList != null && entityList.size() > 0) {
            return (TaProcessNodeAuthProEntity)entityList.get(0);
        }
        return null;
    }
}

