/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.activiti.runtime.service.impl;

import com.biz.eisp.activiti.common.WorkFlowGlobals;
import com.biz.eisp.activiti.designer.processconf.entity.TaProcessEntity;
import com.biz.eisp.activiti.designer.processconf.entity.TaRRoleProcDefEntity;
import com.biz.eisp.activiti.designer.processconf.vo.TaProcessVo;
import com.biz.eisp.activiti.runtime.dao.TaDeploymentDao;
import com.biz.eisp.activiti.runtime.service.TaDeploymentService;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;
import com.biz.eisp.base.utils.StreamUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.delegate.Expression;
import org.activiti.engine.impl.RepositoryServiceImpl;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.task.TaskDefinition;
import org.activiti.engine.repository.Deployment;
import org.activiti.engine.repository.ProcessDefinition;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="taDeploymentService")
@Transactional
public class TaDeploymentServiceImpl
extends BaseServiceImpl
implements TaDeploymentService {
    @Autowired(required=false)
    private RepositoryService repositoryService;
    @Autowired
    private TaDeploymentDao taDeploymentDao;

    @Override
    public void deployProcess(String processId) {
        TaProcessEntity process = this.get(TaProcessEntity.class, (Serializable)((Object)processId));
        if (process == null) {
            throw new BusinessException("\u4e3a\u627e\u5230\u6d41\u7a0b\u8bbe\u8ba1ID");
        }
        Deployment deployment = this.deploy(process);
        this.saveTaRRoleProcDef(deployment);
        process.setProcessState(WorkFlowGlobals.PROCESS_DEPLOY_YES);
        this.updateEntity(process);
    }

    public Deployment deploy(TaProcessEntity process) {
        Deployment deployment = null;
        try {
            deployment = this.repositoryService.createDeployment().addInputStream(process.getProcessKey() + ".bpmn", StreamUtils.byteTOInputStream(process.getProcessXml())).name(process.getProcessKey()).deploy();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return deployment;
    }

    public void saveTaRRoleProcDef(Deployment deployment) {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().deploymentId(deployment.getId()).singleResult();
        ProcessDefinitionEntity processDefinitionEntity = (ProcessDefinitionEntity)((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition(processDefinition.getId());
        Map taskDefinitionMap = processDefinitionEntity.getTaskDefinitions();
        Set taskKeySet = taskDefinitionMap.keySet();
        for (String key : taskKeySet) {
            TaskDefinition td = (TaskDefinition)taskDefinitionMap.get(key);
            Set candidateGroupIdSet = td.getCandidateGroupIdExpressions();
            for (Expression expression : candidateGroupIdSet) {
                String value = expression.getExpressionText();
                TaRRoleProcDefEntity taRRoleProcDefEntity = this.getTaRRoleProcDefEntity(deployment.getId(), value);
                if (taRRoleProcDefEntity != null) continue;
                taRRoleProcDefEntity = new TaRRoleProcDefEntity();
                taRRoleProcDefEntity.setDeploymentId(deployment.getId());
                taRRoleProcDefEntity.setRoleCode(value);
                this.save(taRRoleProcDefEntity);
            }
        }
        ArrayList<String> list = new ArrayList<String>();
        list.add(processDefinition.getId());
        list.add(processDefinition.getKey());
        int s = this.callableStatementByName("PT_ACT_PROCESS_PRO", list);
        if (s <= 0) {
            throw new BusinessException("\u7248\u672c\u7075\u6c14\u590d\u5236\u5931\u8d25\uff01");
        }
    }

    private TaRRoleProcDefEntity getTaRRoleProcDefEntity(String deploymentId, String roleCode) {
        String hql = "from TaRRoleProcDefEntity t where t.deploymentId = ? and t.roleCode = ?";
        List list = this.findByHql(hql, deploymentId, roleCode);
        if (list != null && list.size() > 0) {
            return (TaRRoleProcDefEntity)list.get(0);
        }
        return null;
    }

    @Override
    public List<TaProcessVo> findTaProcessVoList(TaProcessVo taProcessVo, String roleCode, Page page) {
        List<TaProcessVo> list = this.taDeploymentDao.findTaProcessVoList(taProcessVo, roleCode, page);
        return list;
    }
}

