/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.mdm.actrole.vo;

import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.importer.ImpEventHandler;
import com.biz.eisp.base.importer.validator.ValidateException;
import com.biz.eisp.base.utils.ApplicationContextUtils;
import com.biz.eisp.mdm.actrole.entity.TmActRoleEntity;
import com.biz.eisp.mdm.actrole.entity.TmRPositionActRoleEntity;
import com.biz.eisp.mdm.actrole.service.TmActRoleService;
import com.biz.eisp.mdm.actrole.vo.TmActRolePositionRelImportVo;
import com.biz.eisp.mdm.position.entity.TmPositionEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class TmActRolePositionRelHandler
extends ImpEventHandler<TmActRolePositionRelImportVo> {
    private List<TmRPositionActRoleEntity> importDataList = new ArrayList<TmRPositionActRoleEntity>();
    private TmActRoleService tmActRoleService;
    private int succNum = 0;
    private int errNum = 0;
    private StringBuilder errors = new StringBuilder();

    public TmActRolePositionRelHandler() {
        this.tmActRoleService = (TmActRoleService)ApplicationContextUtils.getContext().getBean(TmActRoleService.class);
    }

    @Override
    public void endRow(Map<String, Object> row, TmActRolePositionRelImportVo bean) throws ValidateException {
        String positionCode = bean.getPositionCode();
        String actRoleCode = bean.getActRoleCode();
        TmPositionEntity positionEntity = this.tmActRoleService.findUniqueByProperty(TmPositionEntity.class, "positionCode", positionCode);
        TmActRoleEntity actRoleEntity = this.tmActRoleService.findUniqueByProperty(TmActRoleEntity.class, "roleCode", actRoleCode);
        if (positionEntity == null) {
            this.addErrorMsg("\u804c\u4f4d\u7f16\u7801\uff1a" + positionCode + "\u4e0d\u5b58\u5728");
        }
        if (actRoleEntity == null) {
            this.addErrorMsg("\u89d2\u8272\u7f16\u7801\uff1a" + actRoleCode + "\u4e0d\u5b58\u5728");
        }
        if (positionEntity != null && actRoleEntity != null) {
            TmRPositionActRoleEntity entity = this.getExistTmRPositionActRoleEntity(positionEntity.getId(), actRoleEntity.getId());
            if (entity == null) {
                entity = new TmRPositionActRoleEntity();
            }
            entity.setTmPosition(positionEntity);
            entity.setTmActRole(actRoleEntity);
            this.importDataList.add(entity);
            ++this.succNum;
            this.setSuccNum(this.succNum);
        }
    }

    private TmRPositionActRoleEntity getExistTmRPositionActRoleEntity(String positionId, String actRoleId) {
        String hql = "from TmRPositionActRoleEntity where tmPosition.id = ? and tmActRole.id = ?";
        List tmRPositionActRoleEntityList = this.tmActRoleService.findByHql(hql, positionId, actRoleId);
        if (CollectionUtil.listNotEmptyNotSizeZero(tmRPositionActRoleEntityList)) {
            return (TmRPositionActRoleEntity)tmRPositionActRoleEntityList.get(0);
        }
        return null;
    }

    private void addErrorMsg(String error) throws ValidateException {
        this.errors.append("\u3010\u7b2c" + this.getRowNumber() + "\u884c\u3011:" + error).append("<br/>");
        ++this.errNum;
        if (this.errNum > 200) {
            throw new ValidateException(this.errors.toString());
        }
    }

    @Override
    public void end() {
        if (this.errNum > 0) {
            throw new BusinessException(this.errors.toString());
        }
        this.saveData();
        this.importDataList.clear();
    }

    private void saveData() {
        if (CollectionUtil.listNotEmptyNotSizeZero(this.importDataList)) {
            for (TmRPositionActRoleEntity entity : this.importDataList) {
                this.tmActRoleService.saveOrUpdate(entity);
            }
        }
    }
}

